/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class PublicMembers {
    public static void printConstructors(String sClass) {
        Class cl = PublicMembers.getClassFromName(sClass);
        if (cl != null) {
            PublicMembers.printConstructors(cl);
        }
    }

    public static String[] getConstructors(Class cl) {
        Constructor<?>[] constructors = cl.getDeclaredConstructors();
        String[] v = new String[constructors.length];
        int v_count = 0;
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            int mods = c.getModifiers();
            if (!Modifier.isPublic(mods)) continue;
            Object s = new String();
            Class<?>[] paramTypes = c.getParameterTypes();
            String name = c.getName();
            s = Modifier.toString(mods);
            s = (String)s + " " + name + "(";
            for (int j = 0; j < paramTypes.length; ++j) {
                if (j > 0) {
                    s = (String)s + ", ";
                }
                s = (String)s + PublicMembers.convertParamType(paramTypes[j]);
            }
            s = (String)s + ");";
            v[v_count++] = s;
        }
        String[] newV = null;
        if (v_count > 0) {
            newV = new String[v_count];
            for (int j = 0; j < v_count; ++j) {
                newV[j] = v[j];
            }
        }
        return newV;
    }

    private static void printConstructors(Class cl) {
        String[] v = PublicMembers.getConstructors(cl);
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                System.out.println(v[i]);
            }
        }
    }

    public static void printMethods(String sClass) {
        Class cl = PublicMembers.getClassFromName(sClass);
        if (cl != null) {
            PublicMembers.printMethods(cl);
        }
    }

    public static String[] getMethods(Class cl) {
        Method[] methods = cl.getDeclaredMethods();
        String[] v = new String[methods.length];
        int v_count = 0;
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            int mods = m.getModifiers();
            if (!Modifier.isPublic(mods)) continue;
            Object s = new String();
            Class<?> retType = m.getReturnType();
            Class<?>[] paramTypes = m.getParameterTypes();
            String name = m.getName();
            s = (String)s + Modifier.toString(mods);
            s = (String)s + " " + retType.getName() + " " + name + "(";
            for (int j = 0; j < paramTypes.length; ++j) {
                if (j > 0) {
                    s = (String)s + ", ";
                }
                s = (String)s + PublicMembers.convertParamType(paramTypes[j]);
            }
            s = (String)s + ");";
            v[v_count++] = s;
        }
        String[] newV = null;
        if (v_count > 0) {
            newV = new String[v_count];
            for (int j = 0; j < v_count; ++j) {
                newV[j] = v[j];
            }
        }
        return newV;
    }

    private static void printMethods(Class cl) {
        String[] v = PublicMembers.getMethods(cl);
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                System.out.println(v[i]);
            }
        }
    }

    public static void printFields(String sClass) {
        Class cl = PublicMembers.getClassFromName(sClass);
        if (cl != null) {
            PublicMembers.printFields(cl);
        }
    }

    public static String[] getFields(Class cl) {
        Field[] fields = cl.getDeclaredFields();
        String[] v = new String[fields.length];
        int v_count = 0;
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int mods = f.getModifiers();
            if (!Modifier.isPublic(mods)) continue;
            Object s = new String();
            Class<?> type = f.getType();
            String name = f.getName();
            s = (String)s + Modifier.toString(mods);
            s = (String)s + " " + type.getName() + " " + name + ";";
            v[v_count++] = s;
        }
        String[] newV = null;
        if (v_count > 0) {
            newV = new String[v_count];
            for (int j = 0; j < v_count; ++j) {
                newV[j] = v[j];
            }
        }
        return newV;
    }

    private static void printFields(Class cl) {
        String[] v = PublicMembers.getFields(cl);
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                System.out.println(v[i]);
            }
        }
    }

    public static void printSuperclasses(String sClass) {
        Class cl = PublicMembers.getClassFromName(sClass);
        if (cl != null) {
            PublicMembers.printSuperclasses(cl);
        }
    }

    private static void printSuperclasses(Class cl) {
        Class subclass = cl;
        Class superclass = subclass.getSuperclass();
        while (superclass != null) {
            String className = superclass.getName();
            System.out.println(className);
            subclass = superclass;
            superclass = subclass.getSuperclass();
        }
    }

    public static void printAllMembers(String sClass) {
        Class cl = PublicMembers.getClassFromName(sClass);
        if (cl != null) {
            System.out.println("Class:" + sClass);
            System.out.println("------ Superclasses:");
            PublicMembers.printSuperclasses(cl);
            System.out.println("------ Fields:");
            PublicMembers.printFields(cl);
            System.out.println("------ Ctors:");
            PublicMembers.printConstructors(cl);
            System.out.println("------ Methods:");
            PublicMembers.printMethods(cl);
        }
    }

    private static Class getClassFromName(String sClass) {
        Class<?> cl = null;
        try {
            cl = Class.forName(sClass);
        }
        catch (Throwable e) {
            System.err.println("Class " + sClass + " not found.");
            cl = null;
        }
        return cl;
    }

    private static String convertParamType(Class param) {
        return param.getName();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("  Usage: java PublicMembers <classname>");
            return;
        }
        String name = args[0];
        PublicMembers.printAllMembers(name);
    }
}

