#!/bin/sh
# R Tumanjong Azuah - Feb 2004
#
# Script builds a summary file for the DCS runs in the current reactor
# cycle. The IDL program that builds the summary file is written by
# John Copley and requires an idl runtime license to execute in batch mode.
# The summary file that is created is then copied to various location
# including the DAVE cvs repository where it is added/comitted as necessary.
#
# A cron job is set up to run this script periodically (daily)
#
devel_dir=/home/NCNRWIN/azuah/dave_source/devel/dave/programs/auxiliary/summaryfiles/dcs
stable_dir=/home/NCNRWIN/azuah/dave_source/stable/dave/programs/summaryfiles/dcs
dcs_sum_dir=/home/NCNRWIN/azuah/dave_source/dcs_idlsummary

#--------------------------------------------------------------------------
# run the idl script to generate the summary files
echo "Creating summary file..."
echo ""
cd $dcs_sum_dir
pwd
echo ""
/usr/local/bin/idl -rt=dcs_idlsummary.sav

for fullfile in /tmp/dcsdata/*.sav
do
	if [ -e $fullfile ]
		then
		echo "Copying $fullfile to various locations..."
		file=`basename $fullfile`
		#--------------------------------------------------------------------------
		#copy summary files to Charlotte - windows distribution - devel branch
		echo "Copy to windows distribution - devel branch ..."
		scp $fullfile charlotte:/var/ftp/pub/dave/devel/auxiliary/summaryfiles/dcs/.
		
		#copy summary files to Charlotte - windows distribution - stable branch
		echo "Copy to windows distribution - stable branch ..."
		scp $fullfile charlotte:/var/ftp/pub/dave/stable/summaryfiles/dcs/.
		
		#copy summary files to Charlotte - linux distribution - devel branch
		echo "Copy to linux distribution - devel branch ..."
		scp $fullfile charlotte:/usr/share/ncnr/idl/dave_devel/auxiliary/summaryfiles/dcs/.
		
		#copy summary files to Charlotte - linux distribution - stable branch
		echo "Copy to linux distribution - stable branch ..."
		scp $fullfile charlotte:/usr/share/ncnr/idl/dave/summaryfiles/dcs/.
		
		#copy summary files to Charlotte - sgi distribution - devel branch
		#echo "Copy to sgi distribution - devel branch ..."
		#scp $fullfile charlotte:/usr/share/ncnr/idl/dave_sgi_devel/summaryfiles/dcs/.
		
		#copy summary files to Charlotte - sgi distribution - stable branch
		#echo "Copy to sgi distribution - stable branch ..."
		#scp $fullfile charlotte:/usr/share/ncnr/idl/dave_sgi/summaryfiles/dcs/.
		
		#--------------------------------------------------------------------------
		#copy the results to DAVE devel branch and commit to CVS
		cd $devel_dir
		cp $fullfile .
		#Check if file is currently in CVS
		#If there is a successful match, grep returns an exit status of 0
		# $? in bash contains most recent exit status!
		echo ""
		pwd
		echo "Checking if $file is in CVS repository"
		echo "grep -q -c -i -e "$file" CVS/Entries"
		grep -q -c -i -e "$file" CVS/Entries
		if [ $? == 0 ]
		then
			echo "Commit changes in summary file to CVS - development"
			cvs ci -m "updated" $file &
			wait
		else
			echo "Add and commit new summary file to CVS - development"
			cvs add -kb $file &
			wait
			cvs ci -m "initial inclusion" $file &
			wait
		fi
		
		#copy the results to DAVE stable branch and commit to CVS
		cd $stable_dir
		cp $fullfile .
		echo ""
		pwd
		echo "Checking if $file is in CVS repository"
		echo "grep -q -c -i -e "$file" CVS/Entries"
		grep -q -c -i -e "$file" CVS/Entries
		if [ $? == 0 ]
		then
			echo "Commit changes in summary file to CVS - stable"
			cvs ci -m "updated" $file &
			wait
		else
			echo "Add and commit new summary file to CVS - stable"
			cvs add -kb $file &
			wait
			cvs ci -m "initial inclusion" $file &
			wait
		fi
		
		#--------------------------------------------------------------------------
		#remove files from tmp directory
		echo "Remove $fullfile ..."
		rm -f $fullfile
	fi
done