; Copyright (c)  NV5 Geospatial Solutions, Inc. All
;       rights reserved. Unauthorized reproduction is prohibited.
; ---------------------------------------------------------------------
;
; This function is used as a helper function to set up a local server workspace.  By default
; the workspace is placed in the temporary location specified by the OS.  However, you can tweak
; the workspace with the following properties.
; 
; DATADIR
;   Location of the data directory
;   
; DATAURL
;   URL to the data directory (default uses the file uri scheme http://en.wikipedia.org/wiki/File_URI_scheme)
; 
; DOCROOT
;   Where the docroot exist on the ESE server filesystem
;
; ESEROOT
;   Where the ESE root should exist, right under the DOCROOT
;   
; HOSTNAME
;   The hostname of your box
; 
; JOBSDIR
;   Directory of the jobs directory
; 
; JOBNUMBER
;   What number the job should have
; 
; LOCALDIR
;   The working directory
; 
; LOCALURL
;   The url to the working directory (default uses the file uri scheme http://en.wikipedia.org/wiki/File_URI_scheme)
; 
; PLUGINDIR
;   Directory of the plugins folder
; 
; PROTOCOL
;   Default is FILE:///
; 
; ROOTURL
;   URL to the DOCROOT directory
;   
; ESEURL
;   URL to the ESEROOT directory
; ---------------------------------------------------------------------

pro verifyServer, DATADIR=datadir,             $
                  DATAURL=dataurl,             $
                  DOCROOT=docroot,             $
                  ESEROOT=eseroot,             $
                  HOSTNAME=hostname,           $
                  JOBSDIR=jobsdir,             $
                  JOBNUMBER=jobnumber,         $
                  LOCALDIR=localdir,           $
                  LOCALURL=localurl,           $
                  PLUGINDIR=plugindir,         $
                  PROTOCOL=protocol,           $
                  ROOTURL=rooturl,             $
                  ESEURL=eseurl
  compile_opt idl2,hidden
  
  defsysv,'!SERVER',EXISTS = exists
  if ( ~exists || ~obj_valid(!server) ) then begin
    defsysv,"!SERVER",obj_new("!SERVER",/NOSERVER, DATADIR=datadir,             $
                                                   DATAURL=dataurl,             $
                                                   DOCROOT=docroot,             $
                                                   ESEROOT=eseroot,             $
                                                   HOSTNAME=hostname,           $
                                                   JOBSDIR=jobsdir,             $
                                                   JOBNUMBER=jobnumber,         $
                                                   LOCALDIR=localdir,           $
                                                   LOCALURL=localurl,           $
                                                   PLUGINDIR=plugindir,         $
                                                   PROTOCOL=protocol,           $
                                                   ROOTURL=rooturl,             $
                                                   ESEURL=eseurl)
  endif
end
