/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class FrameTestImageArea
extends RSIImageArea
implements MouseMotionListener,
MouseListener {
    int m_boxw = 100;
    int m_boxh = 100;
    Dimension c_dim;
    boolean m_pressed = false;
    int m_button = 0;
    Vector c_resizelisteners = null;

    public FrameTestImageArea(String imgFile, Dimension dim) {
        super(imgFile, dim);
        this.c_dim = dim;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void addResizeListener(FrameTestImageAreaResizeListener l) {
        if (this.c_resizelisteners == null) {
            this.c_resizelisteners = new Vector();
        }
        if (!this.c_resizelisteners.contains(l)) {
            this.c_resizelisteners.add(l);
        }
    }

    public void removeResizeListener(FrameTestImageAreaResizeListener l) {
        if (this.c_resizelisteners == null) {
            return;
        }
        if (this.c_resizelisteners.contains(l)) {
            this.c_resizelisteners.remove(l);
        }
    }

    public void displayImage() {
        Graphics g = this.getGraphics();
        this.update(g);
    }

    @Override
    public void paint(Graphics g) {
        int xsize = this.getWidth();
        int ysize = this.getHeight();
        if (xsize != -1 && ysize != -1 && (xsize != this.c_dim.width || ysize != this.c_dim.height)) {
            this.c_dim.width = xsize;
            this.c_dim.height = ysize;
            this.setPreferredSize(this.c_dim);
            this.setSize(this.c_dim);
            if (this.c_resizelisteners != null) {
                FrameTestImageAreaResizeListener l = null;
                for (int j = 0; j < this.c_resizelisteners.size(); ++j) {
                    l = (FrameTestImageAreaResizeListener)this.c_resizelisteners.elementAt(j);
                    l.areaResized(xsize, ysize);
                }
            }
        }
        super.paint(g);
    }

    public void setImageFile(String filename) {
        super.loadImage(filename);
        this.displayImage();
    }

    public void drawZoomBox(MouseEvent e) {
        int ey;
        int bx = e.getX() - this.m_boxw / 2;
        bx = bx >= 0 ? bx : 0;
        int by = e.getY() - this.m_boxh / 2;
        by = by >= 0 ? by : 0;
        int ex = bx + this.m_boxw;
        if (ex > this.c_dim.width) {
            ex = this.c_dim.width;
            bx = this.c_dim.width - this.m_boxw;
        }
        if ((ey = by + this.m_boxh) > this.c_dim.height) {
            ey = this.c_dim.height;
            by = this.c_dim.height - this.m_boxh;
        }
        this.displayImage();
        Graphics g = this.getGraphics();
        g.drawImage(this.m_img, bx, by, ex, ey, bx + this.m_boxw / 4, by + this.m_boxh / 4, ex - this.m_boxw / 4, ey - this.m_boxh / 4, null);
        g.setColor(Color.white);
        g.drawRect(bx, by, this.m_boxw, this.m_boxh);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.drawZoomBox(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Graphics g = this.getGraphics();
        if (this.m_pressed && this.m_button == 1) {
            this.drawZoomBox(e);
            g.setColor(Color.white);
            g.drawString("DRAG", 10, 10);
        } else {
            g.setColor(Color.white);
            String s = "(" + e.getX() + "," + e.getY() + ")";
            this.displayImage();
            g.drawString(s, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.m_pressed = true;
        this.m_button = e.getButton();
        if (this.m_button == 1) {
            this.drawZoomBox(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.m_pressed = false;
        this.m_button = 0;
    }
}

