/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map.layer;

import com.rsi.pdf.map.PdfMap;
import com.rsi.pdf.map.datasource.IRasterDataSource;
import com.rsi.pdf.map.layer.AbstractLayer;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class RasterLayer
extends AbstractLayer {
    private Envelope imgExtent = null;
    private int gStateCnt = 0;
    private PDXObjectImage xImage = null;

    public RasterLayer(PdfMap pdfMap, String name, float opacity, IRasterDataSource rasterSource) {
        super(pdfMap, name, opacity);
        if (rasterSource == null || rasterSource.getImage() == null || rasterSource.getImageExtent() == null) {
            throw new IllegalArgumentException("Argument(s) cannot be null");
        }
        this.xImage = rasterSource.getImage();
        this.imgExtent = rasterSource.getImageExtent();
    }

    @Override
    public void render(PDPageContentStream cStream) throws IOException {
        cStream.saveGraphicsState();
        float opaqueness = this.getOpacity();
        if (opaqueness < 1.0f) {
            String gStateName = "GraphicsState_" + this.getName() + this.gStateCnt;
            this.addGraphicsState(gStateName, opaqueness);
            cStream.appendRawCommands("/" + gStateName + " gs\n");
            ++this.gStateCnt;
        }
        Point2D.Float ll = this.toPixel(this.imgExtent.getMinX(), this.imgExtent.getMinY());
        Point2D.Float ur = this.toPixel(this.imgExtent.getMaxX(), this.imgExtent.getMaxY());
        cStream.drawXObject(this.xImage, (float)ll.getX(), (float)ll.getY(), ur.x - ll.x, ur.y - ll.y);
        cStream.restoreGraphicsState();
    }
}

