/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map.layer;

import com.rsi.pdf.map.PdfMap;
import com.rsi.pdf.map.annotation.FeatureAnnotation;
import com.rsi.pdf.map.annotation.IAnnotation;
import com.rsi.pdf.map.annotation.ImageIcon;
import com.rsi.pdf.map.annotation.Label;
import com.rsi.pdf.map.layer.AbstractLayer;
import com.rsi.pdf.map.symbol.ISymbol;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class AnnotationLayer
extends AbstractLayer {
    public static final int RENDER_STYLE_STROKE = 0;
    public static final int RENDER_STYLE_FILL = 1;
    private List<IAnnotation> annotations = null;
    private float borderWidth = 6.0f;
    private boolean drawBorder = false;
    private float pageWidth = this.getPdfPage().findMediaBox().getWidth();
    private float pageHeight = this.getPdfPage().findMediaBox().getHeight();

    public AnnotationLayer(PdfMap pdfMap, String name, float opacity) {
        super(pdfMap, name, opacity);
        this.annotations = new ArrayList<IAnnotation>();
    }

    private void drawImageIcon(PDPageContentStream contentStream, ImageIcon imageIcon) throws IOException {
        AffineTransform rotateXform = new AffineTransform();
        PDXObjectImage ximage = imageIcon.getImage();
        IAnnotation.ScreenLocation location = imageIcon.getMapLocation();
        Point point = imageIcon.getPoint();
        Point2D.Float offset = imageIcon.getOffset();
        float rotation = imageIcon.getRotation();
        Point2D.Float screenPt = null;
        float width = ximage.getWidth();
        float height = ximage.getHeight();
        Rectangle2D.Float shpExtent = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        if (point == null) {
            screenPt = this.toDiscrete(location, shpExtent);
        } else {
            screenPt = this.toPixel(point.getX(), point.getY());
            screenPt = new Point2D.Float(screenPt.x - width / 2.0f, screenPt.y - height / 2.0f);
        }
        if (offset != null) {
            screenPt.setLocation(screenPt.x + offset.x, screenPt.y + offset.y);
        }
        rotateXform.setToRotation(Math.toRadians(-rotation), screenPt.x + width / 2.0f, screenPt.y + height / 2.0f);
        contentStream.saveGraphicsState();
        contentStream.concatenate2CTM(rotateXform);
        contentStream.drawImage(ximage, screenPt.x, screenPt.y);
        contentStream.restoreGraphicsState();
    }

    private void drawLabel(PDPageContentStream contentStream, Label label) throws IOException {
        AffineTransform rotateXform = new AffineTransform();
        AffineTransform xform = new AffineTransform();
        Font font = label.getFont();
        boolean drawDropShadow = label.hasDropShadow();
        Color color = label.getFontColor();
        IAnnotation.ScreenLocation location = label.getLocation();
        Point2D.Float offset = label.getOffset();
        Point point = label.getPoint();
        float rotation = label.getRotation();
        String text = label.getText();
        Label.TextPosition textPosition = label.getTextPosition();
        Point2D.Float screenPt = null;
        Color shadowColor = label.getShadowColor();
        boolean drawTextBox = label.hasTextBox();
        Color textBoxColor = label.getTextBoxColor();
        Shape shadowText = null;
        Rectangle2D.Double textBox = null;
        double textBoxBuffer = 1.0;
        float shadowOffset = 0.0f;
        Shape shape = this.toShape(font, text);
        Rectangle2D shpExtent = shape.getBounds2D();
        if (point == null) {
            screenPt = this.toDiscrete(location, shpExtent);
        } else {
            screenPt = this.toPixel(point.getX(), point.getY());
            screenPt = this.getTextPositionOffset(screenPt, textPosition, shpExtent);
        }
        if (offset != null) {
            screenPt.setLocation(screenPt.x + offset.x, screenPt.y + offset.y);
        }
        xform.setToIdentity();
        xform.translate(screenPt.x, screenPt.y);
        Shape foreText = xform.createTransformedShape(shape);
        if (drawDropShadow) {
            xform.setToIdentity();
            shadowOffset = (float)(shpExtent.getHeight() / 12.0);
            xform.translate(shadowOffset, -shadowOffset);
            shadowText = xform.createTransformedShape(foreText);
        }
        if (drawTextBox) {
            xform.setToIdentity();
            textBox = (Rectangle2D.Double)foreText.getBounds2D();
            textBox.setFrame(textBox.getX() - textBoxBuffer, textBox.getY() - textBoxBuffer, textBox.getWidth() + (double)shadowOffset + textBoxBuffer * 2.0, textBox.getHeight() + (double)shadowOffset + textBoxBuffer * 2.0);
        }
        if (rotation != 0.0f) {
            rotateXform.setToIdentity();
            rotateXform.rotate(Math.toRadians(-rotation), foreText.getBounds2D().getCenterX(), foreText.getBounds2D().getCenterY());
        }
        if (textBox != null) {
            contentStream.setNonStrokingColor(textBoxColor);
            Shape rotatedTextBox = rotateXform.createTransformedShape(textBox);
            this.drawShape(rotatedTextBox, contentStream, 1);
        }
        if (shadowText != null) {
            contentStream.setNonStrokingColor(shadowColor);
            Shape rotatedShadowText = rotateXform.createTransformedShape(shadowText);
            this.drawShape(rotatedShadowText, contentStream, 1);
        }
        contentStream.setNonStrokingColor(color);
        Shape rotatedForeText = rotateXform.createTransformedShape(foreText);
        this.drawShape(rotatedForeText, contentStream, 1);
    }

    @Override
    public void render(PDPageContentStream contentStream) throws IOException {
        contentStream.saveGraphicsState();
        float opaqueness = this.getOpacity();
        if (opaqueness < 1.0f) {
            String gStateName = "GraphicsState_Layer_" + this.getName();
            this.addGraphicsState(gStateName, opaqueness);
            contentStream.appendRawCommands("/" + gStateName + " gs\n");
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            IAnnotation anno = this.annotations.get(i);
            if (anno instanceof Label) {
                Label label = (Label)anno;
                this.drawLabel(contentStream, label);
            }
            if (anno instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)anno;
                this.drawImageIcon(contentStream, imageIcon);
            }
            if (anno instanceof FeatureAnnotation) {
                FeatureAnnotation featureAnno = (FeatureAnnotation)anno;
                Geometry geom = featureAnno.getGeometry();
                ISymbol symbol = featureAnno.getSymbol();
                Map<String, Object> attribs = featureAnno.getAttributeMap();
                this.drawGeometry(geom, symbol, contentStream);
            }
            if (!this.drawBorder) continue;
            contentStream.setStrokingColor(Color.BLACK);
            contentStream.setLineWidth(this.borderWidth);
            this.drawShape(this.createBorder(), contentStream, 0);
            contentStream.setLineWidth(this.borderWidth / 2.0f);
            this.drawShape(this.createNeatline(), contentStream, 0);
        }
        contentStream.restoreGraphicsState();
    }

    private Point2D.Float getTextPositionOffset(Point2D.Float pt, Label.TextPosition txtPosition, Rectangle2D extent) {
        float txtWidth = (float)extent.getWidth();
        float txtHeight = (float)extent.getHeight();
        Point2D.Float point = null;
        switch (txtPosition) {
            case LEFT: {
                point = new Point2D.Float(pt.x - txtWidth - txtHeight, pt.y - txtHeight / 2.0f);
                break;
            }
            case RIGHT: {
                point = new Point2D.Float(pt.x + txtHeight, pt.y - txtHeight / 2.0f);
                break;
            }
            case TOP: {
                point = new Point2D.Float(pt.x - txtWidth / 2.0f, pt.y + txtHeight);
                break;
            }
            case BOTTOM: {
                point = new Point2D.Float(pt.x - txtWidth / 2.0f, pt.y - txtHeight * 2.0f);
                break;
            }
            case CENTER: {
                point = new Point2D.Float(pt.x - txtWidth / 2.0f, pt.y - txtHeight / 2.0f);
                break;
            }
            case UPPER_LEFT: {
                point = new Point2D.Float(pt.x - txtWidth - txtHeight, pt.y + txtHeight / 2.0f);
                break;
            }
            case LOWER_LEFT: {
                point = new Point2D.Float(pt.x - txtWidth - txtHeight, pt.y - txtHeight / 2.0f - txtHeight);
                break;
            }
            case UPPER_RIGHT: {
                point = new Point2D.Float(pt.x + txtHeight, pt.y + txtHeight / 2.0f);
                break;
            }
            case LOWER_RIGHT: {
                point = new Point2D.Float(pt.x + txtHeight, pt.y - txtHeight / 2.0f - txtHeight);
            }
        }
        return point;
    }

    private Point2D.Float toDiscrete(IAnnotation.ScreenLocation location, Rectangle2D rect) {
        Point2D.Float pt = null;
        switch (location) {
            case LOWER_LEFT: {
                pt = new Point2D.Float(20.0f, 20.0f);
                break;
            }
            case LOWER_CENTER: {
                pt = new Point2D.Float((float)((double)(this.pageWidth / 2.0f) - rect.getWidth() / 2.0), 20.0f);
                break;
            }
            case LOWER_RIGHT: {
                pt = new Point2D.Float((float)((double)this.pageWidth - rect.getWidth() - 20.0), 20.0f);
                break;
            }
            case CENTER_LEFT: {
                pt = new Point2D.Float(20.0f, (float)((double)(this.pageHeight / 2.0f) - rect.getHeight() / 2.0));
                break;
            }
            case CENTER_CENTER: {
                pt = new Point2D.Float((float)((double)(this.pageWidth / 2.0f) - rect.getWidth() / 2.0), (float)((double)(this.pageHeight / 2.0f) - rect.getHeight() / 2.0));
                break;
            }
            case CENTER_RIGHT: {
                pt = new Point2D.Float((float)((double)this.pageWidth - rect.getWidth() - 20.0), (float)((double)(this.pageHeight / 2.0f) - rect.getHeight() / 2.0));
                break;
            }
            case UPPER_LEFT: {
                pt = new Point2D.Float(20.0f, (float)((double)this.pageHeight - rect.getHeight() - 20.0));
                break;
            }
            case UPPER_CENTER: {
                pt = new Point2D.Float((float)((double)(this.pageWidth / 2.0f) - rect.getWidth() / 2.0), (float)((double)this.pageHeight - rect.getHeight() - 20.0));
                break;
            }
            case UPPER_RIGHT: {
                pt = new Point2D.Float((float)((double)this.pageWidth - rect.getWidth() - 20.0), (float)((double)this.pageHeight - rect.getHeight() - 20.0));
            }
        }
        return pt;
    }

    private Shape toShape(Font font, String string) {
        BufferedImage image = new BufferedImage(10, 10, 6);
        AffineTransform xform = new AffineTransform();
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        FontMetrics fontMetrics = g2d.getFontMetrics(font);
        GlyphVector v = font.createGlyphVector(fontMetrics.getFontRenderContext(), string);
        Shape s = v.getOutline();
        xform.setToIdentity();
        xform.scale(1.0, -1.0);
        xform.translate(-s.getBounds2D().getX(), -s.getBounds2D().getY() - s.getBounds2D().getHeight());
        return xform.createTransformedShape(s);
    }

    public void drawBorder(boolean draw) {
        this.drawBorder = true;
    }

    public void drawShape(Shape shape, PDPageContentStream contentStream, int renderStyle) throws IOException {
        if (shape != null) {
            contentStream.saveGraphicsState();
            PathIterator pathIterator = shape.getPathIterator(null);
            FlatteningPathIterator iter = new FlatteningPathIterator(pathIterator, 0.25);
            float[] coords = new float[6];
            while (!iter.isDone()) {
                int type = iter.currentSegment(coords);
                switch (type) {
                    case 0: {
                        contentStream.moveTo(coords[0], coords[1]);
                        break;
                    }
                    case 1: {
                        contentStream.lineTo(coords[0], coords[1]);
                        break;
                    }
                    case 4: {
                        contentStream.closeSubPath();
                    }
                }
                iter.next();
            }
            if (renderStyle == 1) {
                contentStream.fill(0);
            } else {
                contentStream.stroke();
            }
            contentStream.restoreGraphicsState();
        }
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    private GeneralPath createNeatline() {
        GeneralPath neatline = new GeneralPath();
        neatline.moveTo(this.borderWidth * 2.0f, this.borderWidth * 2.0f);
        neatline.lineTo(this.pageWidth - this.borderWidth * 2.0f, this.borderWidth * 2.0f);
        neatline.lineTo(this.pageWidth - this.borderWidth * 2.0f, this.pageHeight - this.borderWidth * 2.0f);
        neatline.lineTo(0.0f + this.borderWidth * 2.0f, this.pageHeight - this.borderWidth * 2.0f);
        neatline.closePath();
        return neatline;
    }

    private GeneralPath createBorder() {
        GeneralPath border = new GeneralPath();
        border.moveTo(0.0f + this.borderWidth / 2.0f, this.borderWidth / 2.0f);
        border.lineTo(this.pageWidth - this.borderWidth / 2.0f, this.borderWidth / 2.0f);
        border.lineTo(this.pageWidth - this.borderWidth / 2.0f, this.pageHeight - this.borderWidth / 2.0f);
        border.lineTo(0.0f + this.borderWidth / 2.0f, this.pageHeight - this.borderWidth / 2.0f);
        border.closePath();
        return border;
    }

    public void addAnnotation(IAnnotation anno) {
        this.annotations.add(anno);
    }
}

