/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.geopdf;

import com.vividsolutions.jts.geom.Envelope;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;

public class PdfUtils {
    private static final String GEOGCS = "GEOGCS";
    private static final String PROJCS = "PROJCS";
    private static final String GEO = "GEO";
    private static final String GPTS = "GPTS";
    private static final String LPTS = "LPTS";
    private static final String BOUNDS = "Bounds";
    private static final String WKT = "WKT";
    private static final String GCS = "GCS";
    private static final String VIEWPORT = "Viewport";
    private static final String VIEWPORT_NAME = "AllLayers";
    private static final String MEASURE = "Measure";
    private static final String BBOX = "BBox";
    private static final String VP = "VP";

    public void generateViewPortArray(PDPage page, Envelope mapExtent, String crsWkt) {
        String crsType = GEOGCS;
        if (page != null && mapExtent != null && crsWkt != null) {
            if (crsWkt.contains(PROJCS)) {
                crsType = PROJCS;
            }
        } else {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        COSDictionary measureDict = new COSDictionary();
        measureDict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName(MEASURE));
        measureDict.setItem(COSName.SUBTYPE, (COSBase)COSName.getPDFName(GEO));
        COSArray gpts = new COSArray();
        gpts.add(new COSFloat((float)mapExtent.getMinY()));
        gpts.add(new COSFloat((float)mapExtent.getMinX()));
        gpts.add(new COSFloat((float)mapExtent.getMaxY()));
        gpts.add(new COSFloat((float)mapExtent.getMinX()));
        gpts.add(new COSFloat((float)mapExtent.getMaxY()));
        gpts.add(new COSFloat((float)mapExtent.getMaxX()));
        gpts.add(new COSFloat((float)mapExtent.getMinY()));
        gpts.add(new COSFloat((float)mapExtent.getMaxX()));
        measureDict.setItem(COSName.getPDFName(GPTS), (COSBase)gpts);
        COSArray lpts = new COSArray();
        lpts.add(new COSFloat(0.0f));
        lpts.add(new COSFloat(0.0f));
        lpts.add(new COSFloat(0.0f));
        lpts.add(new COSFloat(1.0f));
        lpts.add(new COSFloat(1.0f));
        lpts.add(new COSFloat(1.0f));
        lpts.add(new COSFloat(1.0f));
        lpts.add(new COSFloat(0.0f));
        measureDict.setItem(COSName.getPDFName(LPTS), (COSBase)lpts);
        COSArray bounds = new COSArray();
        bounds.add(new COSFloat(0.0f));
        bounds.add(new COSFloat(0.0f));
        bounds.add(new COSFloat(0.0f));
        bounds.add(new COSFloat(1.0f));
        bounds.add(new COSFloat(1.0f));
        bounds.add(new COSFloat(1.0f));
        bounds.add(new COSFloat(1.0f));
        bounds.add(new COSFloat(0.0f));
        measureDict.setItem(COSName.getPDFName(BOUNDS), (COSBase)bounds);
        COSDictionary gcs = new COSDictionary();
        gcs.setItem(COSName.TYPE, (COSBase)COSName.getPDFName(crsType));
        gcs.setString(COSName.getPDFName(WKT), crsWkt);
        measureDict.setItem(COSName.getPDFName(GCS), (COSBase)gcs);
        COSArray bbox = new COSArray();
        bbox.add(new COSFloat(page.getMediaBox().getLowerLeftX()));
        bbox.add(new COSFloat(page.getMediaBox().getLowerLeftY()));
        bbox.add(new COSFloat(page.getMediaBox().getUpperRightX()));
        bbox.add(new COSFloat(page.getMediaBox().getUpperRightY()));
        COSDictionary vpDict = new COSDictionary();
        vpDict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName(VIEWPORT));
        vpDict.setString(COSName.NAME, VIEWPORT_NAME);
        vpDict.setItem(COSName.getPDFName(MEASURE), (COSBase)measureDict);
        vpDict.setItem(COSName.getPDFName(BBOX), (COSBase)bbox);
        COSArray vpArray = new COSArray();
        vpArray.add(vpDict);
        page.getCOSDictionary().setItem(COSName.getPDFName(VP), (COSBase)vpArray);
    }
}

