/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cff.CharStringConverter;
import org.apache.fontbox.cff.CharStringRenderer;
import org.apache.fontbox.cff.Type2CharStringParser;
import org.apache.fontbox.cff.charset.CFFCharset;
import org.apache.fontbox.cff.encoding.CFFEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFFFont {
    private String fontname = null;
    private Map<String, Object> topDict = new LinkedHashMap<String, Object>();
    private Map<String, Object> privateDict = new LinkedHashMap<String, Object>();
    private CFFEncoding fontEncoding = null;
    private CFFCharset fontCharset = null;
    private Map<String, byte[]> charStringsDict = new LinkedHashMap<String, byte[]>();

    public String getName() {
        return this.fontname;
    }

    public void setName(String name) {
        this.fontname = name;
    }

    public Object getProperty(String name) {
        Object topDictValue = this.topDict.get(name);
        if (topDictValue != null) {
            return topDictValue;
        }
        Object privateDictValue = this.privateDict.get(name);
        if (privateDictValue != null) {
            return privateDictValue;
        }
        return null;
    }

    public void addValueToTopDict(String name, Object value) {
        if (value != null) {
            this.topDict.put(name, value);
        }
    }

    public Map<String, Object> getTopDict() {
        return this.topDict;
    }

    public void addValueToPrivateDict(String name, Object value) {
        if (value != null) {
            this.privateDict.put(name, value);
        }
    }

    public Map<String, Object> getPrivateDict() {
        return this.privateDict;
    }

    public Collection<Mapping> getMappings() {
        int code;
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        HashSet<String> mappedNames = new HashSet<String>();
        Iterator<Integer> codes = this.fontEncoding.getCodes();
        while (codes.hasNext()) {
            byte[] bytes;
            code = codes.next();
            int sid = this.fontEncoding.getSID(code);
            String charName = this.fontCharset.getName(sid);
            if (charName == null || (bytes = this.charStringsDict.get(charName)) == null) continue;
            Mapping mapping = new Mapping();
            mapping.setCode(code);
            mapping.setSID(sid);
            mapping.setName(charName);
            mapping.setBytes(bytes);
            mappings.add(mapping);
            mappedNames.add(charName);
        }
        code = 256;
        for (CFFCharset.Entry entry : this.fontCharset.getEntries()) {
            byte[] bytes;
            String name = entry.getName();
            if (mappedNames.contains(name) || (bytes = this.charStringsDict.get(name)) == null) continue;
            Mapping mapping = new Mapping();
            mapping.setCode(code++);
            mapping.setSID(entry.getSID());
            mapping.setName(name);
            mapping.setBytes(bytes);
            mappings.add(mapping);
            mappedNames.add(name);
        }
        return mappings;
    }

    public CFFEncoding getEncoding() {
        return this.fontEncoding;
    }

    public void setEncoding(CFFEncoding encoding) {
        this.fontEncoding = encoding;
    }

    public CFFCharset getCharset() {
        return this.fontCharset;
    }

    public void setCharset(CFFCharset charset) {
        this.fontCharset = charset;
    }

    public Map<String, byte[]> getCharStringsDict() {
        return this.charStringsDict;
    }

    public CharStringConverter createConverter() {
        Number defaultWidthX = (Number)this.getProperty("defaultWidthX");
        Number nominalWidthX = (Number)this.getProperty("nominalWidthX");
        return new CharStringConverter(defaultWidthX.intValue(), nominalWidthX.intValue());
    }

    public CharStringRenderer createRenderer() {
        return new CharStringRenderer();
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.fontname + ", topDict=" + this.topDict + ", privateDict=" + this.privateDict + ", encoding=" + this.fontEncoding + ", charset=" + this.fontCharset + ", charStringsDict=" + this.charStringsDict + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Mapping {
        private int mappedCode;
        private int mappedSID;
        private String mappedName;
        private byte[] mappedBytes;

        public List<Object> toType1Sequence() throws IOException {
            CharStringConverter converter = CFFFont.this.createConverter();
            return converter.convert(this.toType2Sequence());
        }

        public List<Object> toType2Sequence() throws IOException {
            Type2CharStringParser parser = new Type2CharStringParser();
            return parser.parse(this.getBytes());
        }

        public int getCode() {
            return this.mappedCode;
        }

        private void setCode(int code) {
            this.mappedCode = code;
        }

        public int getSID() {
            return this.mappedSID;
        }

        private void setSID(int sid) {
            this.mappedSID = sid;
        }

        public String getName() {
            return this.mappedName;
        }

        private void setName(String name) {
            this.mappedName = name;
        }

        public byte[] getBytes() {
            return this.mappedBytes;
        }

        private void setBytes(byte[] bytes) {
            this.mappedBytes = bytes;
        }
    }
}

