/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.javab;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

class logOutput
extends PrintStream {
    private static final String IDL_THREAD_NAME = "IDL";
    private static final String MAIN_THREAD_NAME = "main";
    static OutputStream logfile = null;
    static PrintStream saveStdout;
    static PrintStream saveStderr;
    static ByteArrayOutputStream buffer;
    static String m_eol;
    static int MODE_SENDALLTHREADS;
    static int MODE_SENDMAINTHREAD;
    static int MODE_BUFFERNONMAINTHREADS;
    static int m_iMode;

    public logOutput(PrintStream ps) {
        super(ps);
        this.init(MODE_SENDMAINTHREAD);
    }

    logOutput(PrintStream ps, int iMode) {
        super(ps);
        this.init(iMode);
    }

    private void init(int iMode) {
        m_iMode = iMode;
        if (m_iMode == MODE_BUFFERNONMAINTHREADS) {
            buffer = new ByteArrayOutputStream();
            m_eol = System.getProperty("line.separator");
        }
    }

    public static synchronized native void nativePrint(String var0);

    public static synchronized void flushBuffer() {
        if (m_iMode == MODE_BUFFERNONMAINTHREADS) {
            if (!Thread.currentThread().getName().equals(IDL_THREAD_NAME) && !Thread.currentThread().getName().equals(MAIN_THREAD_NAME)) {
                return;
            }
            if (buffer != null) {
                try {
                    if (buffer.size() > 0) {
                        String sBuffer = buffer.toString();
                        int endIndex = 0;
                        while ((endIndex = sBuffer.indexOf(m_eol)) > 0) {
                            String sNew = sBuffer.substring(0, endIndex);
                            logOutput.nativePrint(sNew);
                            sBuffer = sBuffer.substring(endIndex + m_eol.length());
                        }
                    }
                    buffer.reset();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void start(String f) throws IOException {
        saveStdout = System.out;
        saveStderr = System.err;
        if (f != null) {
            logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)));
        }
        System.setOut(new logOutput(System.out));
        System.setErr(new logOutput(System.err));
    }

    public static void stop() {
        System.setOut(saveStdout);
        System.setErr(saveStderr);
        try {
            if (logfile != null) {
                logfile.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void write(int b) {
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) {
        try {
            if (logfile != null) {
                logfile.write(buf, off, len);
            }
            if (m_iMode == MODE_SENDALLTHREADS) {
                logOutput.nativePrint(new String(buf, off, len));
            } else if (m_iMode == MODE_SENDMAINTHREAD) {
                if (Thread.currentThread().getName().equals(IDL_THREAD_NAME) || Thread.currentThread().getName().equals(MAIN_THREAD_NAME)) {
                    logOutput.nativePrint(new String(buf, off, len));
                }
            } else if (Thread.currentThread().getName().equals(IDL_THREAD_NAME) || Thread.currentThread().getName().equals(MAIN_THREAD_NAME)) {
                logOutput.flushBuffer();
                logOutput.nativePrint(new String(buf, off, len));
            } else {
                buffer.write(buf, off, len);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.setError();
        }
    }

    static {
        buffer = null;
        MODE_SENDALLTHREADS = 0;
        MODE_SENDMAINTHREAD = 1;
        MODE_BUFFERNONMAINTHREADS = 2;
    }
}

