/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map.datasource;

import com.rsi.pdf.map.layer.Feature;
import com.rsi.pdf.map.symbol.DashPattern;
import com.rsi.pdf.map.symbol.ISymbol;
import com.rsi.pdf.map.symbol.LineSymbol;
import com.rsi.pdf.map.symbol.PointSymbol;
import com.rsi.pdf.map.symbol.PolygonSymbol;
import com.rsi.pdf.map.symbol.shape.AbstractShape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class GeoJSONUtil {
    private static final String OBJECT_TYPE = "type";
    private static final String FEATURES = "features";
    private static final String PROPERTIES = "properties";
    private static final String GEOMETRY = "geometry";
    private static final String GEOMETRIES = "geometries";
    private static final String GEOMETRY_TYPE = "type";
    private static final String GEOMETRY_COORDINATES = "coordinates";
    private static final String POINT = "Point";
    private static final String MULTI_POINT = "MultiPoint";
    private static final String LINE_STRING = "LineString";
    private static final String MULTI_LINE_STRING = "MultiLineString";
    private static final String POLYGON = "Polygon";
    private static final String MULTI_POLYGON = "MultiPolygon";
    private static final String GEOMETRY_COLLECTION = "GeometryCollection";
    private static final String FEATURE = "Feature";
    private static final String FEATURE_COLLECTION = "FeatureCollection";
    private static final String SYMBOL = "symbol";
    private static final String FILL_COLOR = "fillColor";
    private static final String OUTLINE_COLOR = "lineColor";
    private static final String SIZE = "size";
    private static final String ROTATION = "rotation";
    private static final String SHAPE = "shape";
    private static final String WIDTH = "lineWidth";
    private static final String DASH_PATTERN = "dashPattern";
    private static final String DASH_PHASE = "dashPhase";
    private static final String POINT_SYMBOL = "Point";
    private static final String LINE_SYMBOL = "Line";
    private static final String POLYGON_SYMBOL = "Polygon";
    private Integer featureId = 0;
    private GeometryFactory geomFactory = new GeometryFactory();

    public List<Feature> parseGeoJSONObject(JSONObject jsonObject, Envelope clipExtent) throws InstantiationException, IllegalAccessException {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        if (jsonObject != null) {
            String type = (String)jsonObject.get("type");
            if ("Point".equals(type) || MULTI_POINT.equals(type) || LINE_STRING.equals(type) || MULTI_LINE_STRING.equals(type) || "Polygon".equals(type) || MULTI_POLYGON.equals(type)) {
                JSONArray coordinates;
                String geometryType = (String)jsonObject.get("type");
                Geometry geom = this.parseGeometry(geometryType, coordinates = (JSONArray)jsonObject.get(GEOMETRY_COORDINATES), clipExtent);
                if (geom != null && !geom.isEmpty()) {
                    Feature feature = new Feature(geom, null);
                    featureList.add(feature);
                }
            } else if (GEOMETRY_COLLECTION.equals(type)) {
                JSONArray geometries = (JSONArray)jsonObject.get(GEOMETRIES);
                int size = geometries.size();
                Geometry[] geoms = new Geometry[size];
                for (int i = 0; i < size; ++i) {
                    Geometry geom;
                    JSONObject geometry = (JSONObject)geometries.get(i);
                    String geometryType = (String)geometry.get("type");
                    JSONArray coordinates = (JSONArray)geometry.get(GEOMETRY_COORDINATES);
                    geoms[i] = geom = this.parseGeometry(geometryType, coordinates, clipExtent);
                }
                GeometryCollection geomCollection = this.geomFactory.createGeometryCollection(geoms);
                if (geomCollection != null && !geomCollection.isEmpty()) {
                    Feature feature = new Feature(geomCollection, null);
                    featureList.add(feature);
                }
            } else if (FEATURE.equals(type)) {
                Feature feature = this.parseFeature(jsonObject, clipExtent);
                if (feature != null) {
                    featureList.add(feature);
                }
            } else if (FEATURE_COLLECTION.equals(type)) {
                JSONArray feats = (JSONArray)jsonObject.get(FEATURES);
                for (JSONObject feature : feats) {
                    Feature mapFeature = this.parseFeature(feature, clipExtent);
                    if (mapFeature == null) continue;
                    featureList.add(mapFeature);
                }
            }
        }
        return featureList;
    }

    private Geometry parseGeometry(String type, JSONArray coordinates, Envelope clipExtent) {
        Geometry geometry = null;
        if ("Point".equals(type)) {
            Point point = this.parsePoint(coordinates);
            Integer n = this.featureId;
            this.featureId = this.featureId + 1;
            point.setUserData(n);
            geometry = point;
        } else if (MULTI_POINT.equals(type)) {
            MultiPoint multiPoint = this.parseMultiPoint(coordinates);
            if (multiPoint != null) {
                Integer n = this.featureId;
                this.featureId = this.featureId + 1;
                multiPoint.setUserData(n);
                geometry = multiPoint;
            }
        } else if (LINE_STRING.equals(type)) {
            LineString line = this.parseLineString(coordinates);
            Integer n = this.featureId;
            this.featureId = this.featureId + 1;
            line.setUserData(n);
            geometry = line;
        } else if (MULTI_LINE_STRING.equals(type)) {
            MultiLineString multiLineString = this.parseMultiLineString(coordinates);
            Integer n = this.featureId;
            this.featureId = this.featureId + 1;
            multiLineString.setUserData(n);
            geometry = multiLineString;
        } else if ("Polygon".equals(type)) {
            Polygon polygon = this.parsePolygon(coordinates);
            Integer n = this.featureId;
            this.featureId = this.featureId + 1;
            polygon.setUserData(n);
            geometry = polygon;
        } else if (MULTI_POLYGON.equals(type)) {
            MultiPolygon multiPolygon = this.parseMultiPolygon(coordinates);
            Integer n = this.featureId;
            this.featureId = this.featureId + 1;
            multiPolygon.setUserData(n);
            geometry = multiPolygon;
        }
        if (clipExtent != null) {
            geometry = geometry.intersection(this.toPolygon(clipExtent));
        }
        return geometry;
    }

    private Polygon toPolygon(Envelope envelope) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY())};
        return this.geomFactory.createPolygon(coords);
    }

    private Coordinate parseCoordinate(JSONArray coordinates) {
        Number x = (Number)coordinates.get(0);
        Number y = (Number)coordinates.get(1);
        return new Coordinate(x.doubleValue(), y.doubleValue());
    }

    private Point parsePoint(JSONArray coordinates) {
        if (coordinates.get(0) instanceof List) {
            coordinates = (JSONArray)coordinates.get(0);
        }
        Coordinate coord = this.parseCoordinate(coordinates);
        return this.geomFactory.createPoint(coord);
    }

    private MultiPoint parseMultiPoint(JSONArray coordinates) {
        JSONArray jsonPoints = coordinates;
        Coordinate[] coords = new Coordinate[coordinates.size()];
        for (int i = 0; i < jsonPoints.size(); ++i) {
            Coordinate coord;
            coords[i] = coord = this.parseCoordinate((JSONArray)jsonPoints.get(i));
        }
        return this.geomFactory.createMultiPoint(coords);
    }

    private LineString parseLineString(JSONArray coordinates) {
        int size = coordinates.size();
        Coordinate[] coords = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            Coordinate coord;
            JSONArray jsonPoint = (JSONArray)coordinates.get(i);
            coords[i] = coord = this.parseCoordinate(jsonPoint);
        }
        return this.geomFactory.createLineString(coords);
    }

    private LinearRing parseLinearRing(JSONArray coordinates) {
        int size = coordinates.size();
        Coordinate[] coords = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            Coordinate coord;
            JSONArray jsonPoint = (JSONArray)coordinates.get(i);
            coords[i] = coord = this.parseCoordinate(jsonPoint);
        }
        if (!coords[0].equals2D(coords[coords.length - 1])) {
            coords = Arrays.copyOf(coords, coords.length + 1);
            coords[coords.length - 1] = new Coordinate(coords[0]);
        }
        return this.geomFactory.createLinearRing(coords);
    }

    private MultiLineString parseMultiLineString(JSONArray coordinates) {
        int size = coordinates.size();
        LineString[] lines = new LineString[size];
        for (int i = 0; i < size; ++i) {
            LineString lineString;
            JSONArray jsonLineString = (JSONArray)coordinates.get(i);
            lines[i] = lineString = this.parseLineString(jsonLineString);
        }
        return this.geomFactory.createMultiLineString(lines);
    }

    private Polygon parsePolygon(JSONArray coordinates) {
        int size = coordinates.size();
        LinearRing[] holes = new LinearRing[size - 1];
        LinearRing outerRing = null;
        JSONArray jsonRing = (JSONArray)coordinates.get(0);
        outerRing = this.parseLinearRing(jsonRing);
        for (int i = 1; i < size; ++i) {
            LinearRing linearRing;
            JSONArray jsonInnerRing = (JSONArray)coordinates.get(i);
            holes[i - 1] = linearRing = this.parseLinearRing(jsonInnerRing);
        }
        return this.geomFactory.createPolygon(outerRing, holes);
    }

    private MultiPolygon parseMultiPolygon(JSONArray coordinates) {
        int size = coordinates.size();
        Polygon[] polys = new Polygon[size];
        for (int i = 0; i < size; ++i) {
            Polygon polygon;
            polys[i] = polygon = this.parsePolygon((JSONArray)coordinates.get(i));
        }
        return this.geomFactory.createMultiPolygon(polys);
    }

    private Feature parseFeature(JSONObject feature, Envelope clipExtent) throws InstantiationException, IllegalAccessException {
        Feature mapFeature = null;
        Map jsonGeometry = (Map)feature.get(GEOMETRY);
        String jsonGeometryType = (String)jsonGeometry.get("type");
        JSONArray jsonCoordinates = (JSONArray)jsonGeometry.get(GEOMETRY_COORDINATES);
        JSONObject jsonProperties = (JSONObject)feature.get(PROPERTIES);
        Map jsonSymbol = (Map)feature.get(SYMBOL);
        Geometry geometry = this.parseGeometry(jsonGeometryType, jsonCoordinates, clipExtent);
        if (geometry != null && !geometry.isEmpty()) {
            Map<String, Object> properties = this.parseProperties(jsonProperties);
            ISymbol symbol = this.parseSymbol(jsonSymbol);
            mapFeature = new Feature(geometry, symbol);
            for (int n = 0; n < properties.size(); ++n) {
                mapFeature.getAttributeMap().putAll(properties);
            }
        }
        return mapFeature;
    }

    private Map<String, Object> parseProperties(Map<String, Object> jsonProperties) {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        for (String key : jsonProperties.keySet()) {
            Object value = jsonProperties.get(key);
            if (key.equals(GEOMETRY)) continue;
            propertiesMap.put(key, value);
        }
        return propertiesMap;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ISymbol parseSymbol(Map jsonSymbol) throws InstantiationException, IllegalAccessException {
        void var2_6;
        Object var2_2 = null;
        Object objType = jsonSymbol.get("type");
        if (objType == null) throw new IllegalArgumentException(String.valueOf(this.getClass()) + " : null symbol");
        String type = (String)objType;
        if ("Point".equals(type)) {
            Object objShape;
            Object objRot;
            Number number;
            Object objSize;
            Object objFillColor;
            Color outlineColor = Color.RED;
            Color fillColor = null;
            float size = 10.0f;
            float rotation = 0.0f;
            String shapeName = null;
            boolean useFill = false;
            boolean useOutline = true;
            Object objOutlineColor = jsonSymbol.get(OUTLINE_COLOR);
            if (objOutlineColor != null) {
                JSONArray outlineColorArray = (JSONArray)objOutlineColor;
                outlineColor = this.parseColor(outlineColorArray);
            }
            if ((objFillColor = jsonSymbol.get(FILL_COLOR)) != null) {
                JSONArray fillColorArray = (JSONArray)objFillColor;
                fillColor = this.parseColor(fillColorArray);
                useFill = true;
            }
            if ((objSize = jsonSymbol.get(SIZE)) != null && (number = (Number)objSize).floatValue() > 0.0f) {
                size = number.floatValue();
            }
            if ((objRot = jsonSymbol.get(ROTATION)) != null) {
                Number number2 = (Number)objRot;
                rotation = number2.floatValue();
            }
            if ((objShape = jsonSymbol.get(SHAPE)) != null) {
                shapeName = (String)objShape;
            }
            PointSymbol pointSymbol = this.generatePointSymbol(shapeName, useFill, fillColor, useOutline, outlineColor, rotation, size);
            return var2_6;
        } else if (LINE_SYMBOL.equals(type)) {
            Object objDashPhase;
            Object objDashPattern;
            Object objLineWidth;
            Color outlineColor = Color.WHITE;
            float width = 0.1f;
            float[] dashPattern = null;
            float dashPhase = 0.0f;
            Object objOutlineColor = jsonSymbol.get(OUTLINE_COLOR);
            if (objOutlineColor != null) {
                JSONArray outlineColorArray = (JSONArray)objOutlineColor;
                outlineColor = this.parseColor(outlineColorArray);
            }
            if ((objLineWidth = jsonSymbol.get(WIDTH)) != null) {
                Number number = (Number)objLineWidth;
                width = number.floatValue();
            }
            if ((objDashPattern = jsonSymbol.get(DASH_PATTERN)) != null) {
                JSONArray dashPatternArray = (JSONArray)objDashPattern;
                dashPattern = this.getFloatArrayValue(dashPatternArray);
            }
            if ((objDashPhase = jsonSymbol.get(DASH_PHASE)) != null) {
                Number number = (Number)objDashPhase;
                dashPhase = number.floatValue();
            }
            LineSymbol lineSymbol = this.generateLineSymbol(outlineColor, width, dashPattern, dashPhase);
            return var2_6;
        } else {
            Object objDashPhase;
            Object objDashPattern;
            Number number;
            Object objLineWidth;
            Object objFillColor;
            if (!"Polygon".equals(type)) throw new IllegalArgumentException(String.valueOf(this.getClass()) + " : unknown symbol type");
            Color outlineColor = Color.BLACK;
            Color fillColor = null;
            float width = 0.1f;
            float[] dashPattern = null;
            float dashPhase = 0.0f;
            boolean useFill = false;
            boolean useOutline = true;
            Object objOutlineColor = jsonSymbol.get(OUTLINE_COLOR);
            if (objOutlineColor != null) {
                JSONArray outlineColorArray = (JSONArray)objOutlineColor;
                outlineColor = this.parseColor(outlineColorArray);
            }
            if ((objFillColor = jsonSymbol.get(FILL_COLOR)) != null) {
                JSONArray fillColorArray = (JSONArray)objFillColor;
                fillColor = this.parseColor(fillColorArray);
                useFill = true;
            }
            if ((objLineWidth = jsonSymbol.get(WIDTH)) != null && (number = (Number)objLineWidth).floatValue() > 0.0f) {
                width = number.floatValue();
            }
            if ((objDashPattern = jsonSymbol.get(DASH_PATTERN)) != null) {
                JSONArray dashPatternArray = (JSONArray)objDashPattern;
                dashPattern = this.getFloatArrayValue(dashPatternArray);
            }
            if ((objDashPhase = jsonSymbol.get(DASH_PHASE)) != null) {
                Number number3 = (Number)objDashPhase;
                dashPhase = number3.floatValue();
            }
            PolygonSymbol polygonSymbol = this.generatePolygonSymbol(useOutline, outlineColor, useFill, fillColor, width, dashPattern, dashPhase);
        }
        return var2_6;
    }

    private PolygonSymbol generatePolygonSymbol(boolean useOutline, Color outlineColor, boolean useFill, Color fillColor, float lineWidth, float[] dashPattern, float dashPhase) {
        PolygonSymbol pSym = new PolygonSymbol();
        pSym.getLineSymbol().setColor(outlineColor);
        pSym.setDrawoutline(true);
        if (fillColor != null) {
            pSym.setFillColor(fillColor);
            pSym.setDrawFill(true);
        }
        if (dashPattern != null) {
            DashPattern pattern = new DashPattern(dashPattern, dashPhase);
            pSym.getLineSymbol().setDashPattern(pattern);
        }
        pSym.getLineSymbol().setWidth(lineWidth);
        return pSym;
    }

    private LineSymbol generateLineSymbol(Color lineColor, float lineWidth, float[] dashPattern, float dashPhase) {
        LineSymbol lSym = new LineSymbol();
        lSym.setColor(lineColor);
        lSym.setWidth(lineWidth);
        if (dashPattern != null) {
            DashPattern pattern = new DashPattern(dashPattern, dashPhase);
            lSym.setDashPattern(pattern);
        }
        return lSym;
    }

    private PointSymbol generatePointSymbol(String shapeName, boolean useFill, Color fillColor, boolean useOutline, Color outlineColor, float rotation, float size) throws InstantiationException, IllegalAccessException {
        Class shapeClass = this.getFQClassName(shapeName);
        PointSymbol ptSym = null;
        ptSym = shapeClass != null ? new PointSymbol((AbstractShape)shapeClass.newInstance()) : new PointSymbol();
        if (ptSym.hasFill()) {
            ptSym.setFillColor(fillColor);
        }
        if (ptSym.hasOutline()) {
            ptSym.setOutlineColor(outlineColor);
        }
        ptSym.setRotation(rotation);
        ptSym.setSize(size);
        return ptSym;
    }

    private Color parseColor(JSONArray jsonColor) {
        int red = this.getNumberValue(jsonColor, 0).intValue();
        int green = this.getNumberValue(jsonColor, 1).intValue();
        int blue = this.getNumberValue(jsonColor, 2).intValue();
        return new Color(red, green, blue);
    }

    private Number getNumberValue(JSONArray array, int index) {
        Object obj = array.get(index);
        Number val = (Number)obj;
        return val;
    }

    private float[] getFloatArrayValue(JSONArray jsonArray) {
        int size = jsonArray.size();
        float[] floatArray = new float[size];
        for (int i = 0; i < size; ++i) {
            Object obj = jsonArray.get(i);
            Number num = (Number)obj;
            floatArray[i] = num.floatValue();
        }
        return floatArray;
    }

    private Class getFQClassName(String shapeName) {
        Class<?> clazz = null;
        String fullPath = "com.rsi.pdf.map.symbol.shape." + shapeName;
        try {
            clazz = Class.forName(fullPath);
        }
        catch (ClassNotFoundException cnfe) {
            clazz = null;
        }
        return clazz;
    }
}

