/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.javab;

import com.rsi.javab.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflQuery {
    public static void printConstructors(Class cl) {
        Constructor<?>[] constructors = cl.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            Class<?>[] paramTypes = c.getParameterTypes();
            String name = c.getName();
            System.out.print(Modifier.toString(c.getModifiers()));
            System.out.print(" " + name + "(");
            for (int j = 0; j < paramTypes.length; ++j) {
                if (j > 0) {
                    System.out.print(", ");
                }
                System.out.print(paramTypes[j].toString());
            }
            System.out.println(");");
        }
    }

    public static void printMethods(Class cl) {
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            Class<?> retType = m.getReturnType();
            Class<?>[] paramTypes = m.getParameterTypes();
            String name = m.getName();
            System.out.print(Modifier.toString(m.getModifiers()));
            System.out.print(" " + retType.getName() + " " + name + "(");
            for (int j = 0; j < paramTypes.length; ++j) {
                if (j > 0) {
                    System.out.print(", ");
                }
                System.out.print(paramTypes[j].getName());
            }
            System.out.println(");");
        }
    }

    public static void printFields(Class cl) {
        Field[] fields = cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            Class<?> type = f.getType();
            String name = f.getName();
            System.out.print(Modifier.toString(f.getModifiers()));
            System.out.println(" " + type.getName() + " " + name + ";");
        }
    }

    public static void printSuperclasses(Object o) {
        Class<?> subclass = o.getClass();
        Class<?> superclass = subclass.getSuperclass();
        while (superclass != null) {
            String className = superclass.getName();
            System.out.println(className);
            subclass = superclass;
            superclass = subclass.getSuperclass();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("  Usage: java com.rsi.javab.ReflectionUtil <classname>");
            return;
        }
        String name = args[0];
        Class cl = ClassUtil.findClass(name);
        if (cl != null) {
            Class supercl = cl.getSuperclass();
            System.out.println("Class " + name);
            System.out.println("------ Ctors:");
            ReflQuery.printConstructors(cl);
            System.out.println("------ Methods:");
            ReflQuery.printMethods(cl);
            System.out.println("------ Fields:");
            ReflQuery.printFields(cl);
        } else {
            System.out.println("Class not found.");
        }
    }
}

