/*
 * Decompiled with CFR 0.152.
 */
package com.idl.javaidl;

import com.idl.javaidl.JIDLException;
import com.idl.javaidl.JIDLNotifyListener;
import com.idl.javaidl.JIDLObjectI;
import com.idl.javaidl.JIDLOutputListener;
import com.idl.javaidl.JIDLPAL;
import com.idl.javaidl.JIDLProcessInitializer;
import java.io.Serializable;

public class JIDLObject
implements JIDLObjectI,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient JIDLPAL m_interface;
    private String m_sClass;
    private boolean m_isDestroyed;

    protected JIDLObject(String sClass, String sProcessName) {
        this.m_sClass = sClass;
        this.m_interface = new JIDLPAL(this, sProcessName);
        this.m_isDestroyed = false;
    }

    protected JIDLObject(String sClass, int iOPSFlags, String sProcessName) {
        this(sClass, sProcessName);
    }

    public void createObject() {
        this.createObject(0, null, null, null);
    }

    public void createObject(JIDLProcessInitializer initializer) {
        this.createObject(0, null, null, initializer);
    }

    public void createObject(int argc, Object[] argv, int[] argpal) {
        this.createObject(argc, argv, argpal, null);
    }

    @Override
    public void createObject(int argc, Object[] argv, int[] argpal, JIDLProcessInitializer initializer) {
        if (this.m_isDestroyed) {
            throw new JIDLException(-1L, "Wrapper has been destroyed.");
        }
        if (this.m_interface != null) {
            this.m_interface.createObject(this.m_sClass, argc, argv, argpal, initializer);
            this.initListeners();
        }
    }

    @Override
    public void initListeners() {
    }

    @Override
    public void destroyObject() {
        if (this.m_interface != null) {
            this.m_interface.destroyObject();
        }
        this.m_interface = null;
        this.m_isDestroyed = true;
    }

    @Override
    public boolean isObjectCreated() {
        boolean isCreated = false;
        if (this.m_interface != null) {
            isCreated = this.m_interface.isObjectCreated();
        }
        return isCreated;
    }

    @Override
    public boolean isObjectDisplayable() {
        return false;
    }

    public boolean isObjCreated() {
        return this.isObjectCreated();
    }

    @Override
    public void abort() {
        if (this.m_interface != null) {
            this.m_interface.abort();
        }
    }

    @Override
    public long getCookie() {
        long cookie = -1L;
        if (this.m_interface != null) {
            cookie = this.m_interface.getCookie();
        }
        return cookie;
    }

    @Override
    public String getIDLObjectClassName() {
        return this.m_sClass;
    }

    public String getClassName() {
        return this.getIDLObjectClassName();
    }

    @Override
    public String getProcessName() {
        if (this.m_interface != null) {
            return this.m_interface.getProcessName();
        }
        return "";
    }

    @Override
    public void setProcessName(String process) {
        if (this.m_interface != null) {
            this.m_interface.setProcessName(process);
        }
    }

    public void callProcedure(String sMethodName) {
        if (this.m_interface != null) {
            this.m_interface.callProcedure(sMethodName, 0, null, null);
        }
    }

    @Override
    public void callProcedure(String sMethodName, int argc, Object[] argv, int[] argpal) {
        if (this.m_interface != null) {
            this.m_interface.callProcedure(sMethodName, argc, argv, argpal);
        }
    }

    public Object callFunction(String sMethodName, int iPalFlag) {
        return this.callFunction(sMethodName, 0, null, null, iPalFlag);
    }

    @Override
    public Object callFunction(String sMethodName, int argc, Object[] argv, int[] argpal, int iPalFlag) {
        Object result = null;
        if (this.m_interface != null) {
            result = this.m_interface.callFunction(sMethodName, argc, argv, argpal, iPalFlag);
        }
        return result;
    }

    @Override
    public Object getProperty(String sProperty, int iPalFlag) {
        Object result = null;
        if (this.m_interface != null) {
            result = this.m_interface.getProperty(sProperty, iPalFlag);
        }
        return result;
    }

    @Override
    public void setProperty(String sProperty, Object obj, int iPalFlag) {
        if (this.m_interface != null) {
            this.m_interface.setProperty(sProperty, obj, iPalFlag);
        }
    }

    public String getObjVariableName() {
        return this.getIDLObjectVariableName();
    }

    @Override
    public String getIDLObjectVariableName() {
        String result = "";
        if (this.m_interface != null) {
            result = this.m_interface.getIDLObjectVariableName();
        }
        return result;
    }

    @Override
    public Object getIDLVariable(String sVar) {
        Object result = null;
        if (this.m_interface != null) {
            result = this.m_interface.getIDLVariable(sVar);
        }
        return result;
    }

    @Override
    public void setIDLVariable(String sVar, Object obj) {
        if (this.m_interface != null) {
            this.m_interface.setIDLVariable(sVar, obj);
        }
    }

    @Override
    public void executeString(String sCmd) {
        if (this.m_interface != null) {
            this.m_interface.executeString(sCmd);
        }
    }

    @Override
    public void addIDLOutputListener(JIDLOutputListener listener) {
        if (this.m_interface != null && listener != null) {
            this.m_interface.addIDLOutputListener(listener);
        }
    }

    @Override
    public void removeIDLOutputListener(JIDLOutputListener listener) {
        if (this.m_interface != null && listener != null) {
            this.m_interface.removeIDLOutputListener(listener);
        }
    }

    @Override
    public void addIDLNotifyListener(JIDLNotifyListener listener) {
        if (this.m_interface != null && listener != null) {
            this.m_interface.addIDLNotifyListener(listener);
        }
    }

    @Override
    public void removeIDLNotifyListener(JIDLNotifyListener listener) {
        if (this.m_interface != null && listener != null) {
            this.m_interface.removeIDLNotifyListener(listener);
        }
    }

    public String toString() {
        if (this.isObjectCreated()) {
            return this.getClass().getName() + "[class=" + this.m_sClass + ", cookie=" + this.getCookie() + ", process=" + this.getProcessName() + "]";
        }
        return this.getClass().getName() + "[class=" + this.m_sClass + ", cookie=" + this.getCookie() + ", Object not created]";
    }
}

