; $Id: qxy_to_hkl.pro,v 1.2 2012/06/26 15:11:33 kneller Exp $


;Convert Qxy to hkl values.

;###############################################################################
function Qxy_to_hkl,Qxy,a,b,c,alpha,beta,gamma,o1,o2

    ;FOR MOUSE INTERACTIONS IN THE SCATTERING PLANE:

    ;GIVEN Qxy THIS GIVES THE hkl VALUES FOR A POINT IN THE SCATTERING
    ;PLANE.  THIS WILL BE EXTREMELY USEFUL WHEN THE USER WANTS TO
    ;SELECT A POINT IN THE SCATTERING PLANE WITH THE MOUSE AND
    ;HAVE THE PROGRAM PRODUCE Q,ki,kf, AND OTHER ITEMS.


    ;ADD A zero IN THE Z COMPONENT IF ONLY x,y, COMPONENTS SPECIFIED.
    if n_elements(Qxy) eq 2 then Q = [Qxy,0.0] else Q = Qxy




;1) ;GET RECIPROCAL LATTICE VECTORS
    val = recip_lattice(a,b,c,alpha,beta,gamma)
    b1    = val.b123.b1
    b2    = val.b123.b2
    b3    = val.b123.b3


;2) ;GET o1vec,o2vec IN 1/ang
;THE FOLLOWING SETS THE AXES ALONG o1,o2
    o1vec = (o1[0]*b1 + o1[1]*b2 + o1[2]*b3)
    o2vec = (o2[0]*b1 + o2[1]*b2 + o2[2]*b3)
    mago1vec = sqrt(dotp(o1vec,o1vec))
    mago2vec = sqrt(dotp(o2vec,o2vec))

;3) ; GET UNIT VECTORS ALONG o1,o2
    ;CREATE UNIT VECTORS ALONG THE o1,o2 DIRECTIONS ---  THIS SHOULD NOT BE USED IN
    xhat_o1 = o1vec/mago1vec                            ;GENERAL SINCE THEY ARE ALONG
    yhat_o2 = o2vec/mago2vec                            ;THE ORIENTATION VECTOR DIRECTIONS
                                                        ;AND MAY NOT BE ORTHOGONAL.

;4) DEFINE  xhat,yhat, UNIT VECTORS IN THE SCATTERING PLANE
;           zhat       PERPENDICULAR TO THE SCATTERING PLANE
    xhat = xhat_o1
    xhat = xhat/sqrt(dotp(xhat,xhat))
    zhat = crossp(xhat_o1,yhat_o2)
    zhat = zhat/sqrt(dotp(zhat,zhat))
    yhat = crossp(zhat,xhat)
    yhat = yhat/sqrt(dotp(yhat,yhat))

    ;NOW GET xhat,yhat IN hkl
;5) GET THE hkl VALUES FOR xhat,yhat SO INDICES DESCRIBE THE UNIT VECTORS
    xhat_hkl = LK_cramer(b1,b2,b3,xhat)
    yhat_hkl = LK_cramer(b1,b2,b3,yhat)
    zhat_hkl = LK_cramer(b1,b2,b3,zhat)

    Qhkl = Q[0]*xhat_hkl + Q[1] * yhat_hkl + Q[2]*zhat_hkl
    return,Qhkl
end;Qxy_to_hkl


