; $Id: qe.pro,v 1.2 2012/06/26 15:11:33 kneller Exp $

;Calculate the Q and energy harmonics to nvec orders for a given ki,kf pair.




;####################################################################
function QE,ki,kf,nvec

        ;CALCULATE ALL OF THE Q AND E VALUES FOR ONE POINT ONLY.
        Q = ki - kf
        if n_elements(nvec) eq 0 then nvec = 5

        kiarr = dblarr(3,nvec)
        kfarr = dblarr(3,nvec)
        Qarr  = dblarr(3,nvec,nvec)
        QMagarr = dblarr(nvec,nvec)
        Earr  = dblarr(nvec,nvec)
        for i=1,nvec do begin
            kiarr[*,i-1] = i*ki
            kfarr[*,i-1] = i*kf
        endfor;i
        for i=0,nvec-1 do begin
            for j=0,nvec-1 do begin
                ;CALCULATE THE Q'S FOR THE HARMONICS
                Qarr[*,i,j] = kiarr[*,i] - kfarr[*,j]
                QMagarr[i,j] = sqrt(dotp(Qarr[*,i,j],Qarr[*,i,j]))
                ;CALCULATE THE ENERGIES FOR THE HARMONICS
                Earr[i,j] = calc_E_from_kvec(kiarr[*,i]) - calc_E_from_kvec(kfarr[*,j])

            endfor;j
        endfor;i

   return,{Q:Q,kiarr:kiarr,kfarr:kfarr,Qarr:Qarr,QMagarr:QMagarr,Earr:Earr}
end;QE