; $Id$
;###############################################################################
;+
; NAME:
;   wd_data_dir
;
; PURPOSE:
;   Basic file dialog widgets to set/view raw data and working directoris.
;   Provide an alternative to using the Preferences interface.
;
; CATEGORY:
;   DAVE Main Tool
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; 2008
;-


;###############################################################################
;
pro set_data_dir, group_leader=group_leader, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

task = 1
title = "Define the Raw Data Directory"
wd_data_dir, task, title, oDAVETool, workDir=workDir, dataDir=dataDir, group_leader=grpl

end


;###############################################################################
pro set_work_dir, group_leader=group_leader, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

task = 2
title = "Define Working (Reduced Data) Directory"
wd_data_dir, task, title, oDAVETool, workDir=workDir, dataDir=dataDir, group_leader=grpl

end

;###############################################################################
pro set_datawork_dir, group_leader=group_leader, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

task = 3
title = "Define Data and Working Directories"
wd_data_dir, task, title, oDAVETool, workDir=workDir, dataDir=dataDir, group_leader=grpl

end

;###############################################################################
pro show_datawork_dir, group_leader=group_leader, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

task = 4
title="Current Data and Woring directory settings"
wd_data_dir, task, title, oDAVETool, workDir=workDir, dataDir=dataDir, group_leader=grpl

end




;###############################################################################
pro wd_data_dir, task, title, oDAVETool, workDir=workDir, dataDir=dataDir, group_leader=grpl

if (n_params() ne 3) then return

if (task ne 4) then begin
   if (~obj_valid(oDAVETool)) then return
   oSystem = oDAVETool->GetSystem()
   if (~obj_valid(oSystem)) then return
   
   ; Syncronize directories with tools that are currently active
   oGeneral = oSystem->GetByIdentifier('/REGISTRY/SETTINGS/GENERAL_SETTINGS')
   if (~obj_valid(oGeneral)) then return
endif

case task of
   1: begin
      result = dialog_pickfile(/directory,dialog_parent=grpl,title=title, path=dataDir, file=dataDir)
      if (result eq '') then return
      oGeneral->SetProperty, data_directory=result
      oGeneral->_UpdateCurrentTools,/update_tool, data_directory=result
      oDAVETool->_SaveSettings
   end
   
   2: begin
      result = dialog_pickfile(/directory,dialog_parent=grpl,title=title, path=workDir, file=workDir)
      if (result eq '') then return
      oGeneral->SetProperty, working_directory=result
      oGeneral->_UpdateCurrentTools,/update_tool, working_directory=result
      oDAVETool->_SaveSettings
   end
   
   3: begin
      result = dialog_pickfile(/directory,dialog_parent=grpl,title=title, path=dataDir, file=dataDir)
      if (result eq '') then return
      oGeneral->SetProperty, working_directory=result, data_directory=result
      oGeneral->_UpdateCurrentTools,/update_tool, working_directory=result, data_directory=result
      oDAVETool->_SaveSettings
   end
   
   
   4: begin
      msg = ["Raw Data Directory: "+dataDir $
            ,"Working Directory:  "+workDir ]
            
      oDAVETool->ErrorMessage, msg, severity=0, title=title
   end

   else:
endcase


end









;===============================================================================
; set_pdfreader
;
; PURPOSE:
;   Lets user specify a PDF Reader app. The specified
;   value is stored in a global variable and also saved for future DAVE
;   sessions.
;
; PARAMETERS:
;
pro set_pdfreader, group_leader=group_leader, _EXTRA=etc

dave_defs=*!dave_defaults  ; Retrieve the global var
PDFReader=dave_defs.PDFReader ; and the current setting
;print,"Current pdfreader is ",PDFReader

; check and then exit if reader's selected reader is okay
readerNotOkay = 'Yes'
if (strtrim(PDFReader,2) ne '') then begin
    message_text = ['Your PDF reader is currently set to:',PDFReader, $
                    'Are you sure you want to change this setting?']
    readerNotOkay = dialog_message(message_text,/question,/default_no, $
                                   title='PDF Reader Setting')
    readerBaseDir = strmid(PDFReader,0,strpos(PDFReader,!delimiter,/reverse_search))
endif
if (readerNotOkay eq 'No') then return ; nothing to do

; let user select select a reader
if n_elements(group_leader) gt 0 then begin
    acroread = dialog_pickfile(dialog_parent = group_leader,/read, $
                               title="Please select your PDF reader", $
                               path=readerBaseDir, $
                               file = PDFReader)
endif else begin
    acroread = dialog_pickfile(/read, title="Please select your PDF reader", $
                               path=readerBaseDir, $
                               file = PDFReader)
endelse

if (acroread eq '' or acroread eq ' ') then return

dave_defs.PDFReader=acroread
pdd=!dave_defaults
ptr_free,pdd
pdd=ptr_new(dave_defs)
save,filename=!defaults_file,pdd

defsysv,'!dave_defaults',pdd
print,"New pdfreader is ",(*!dave_defaults).PDFReader

return
end
;-------------------------------------------------------------------------------



;===============================================================================
; set_browser
;
; PURPOSE:
;   Lets user specify a web browser.
;   
; PARAMETERS:
;
pro set_browser, group_leader=group_leader, _EXTRA=etc

dave_defs=*!dave_defaults
web_browser = dave_defs.web_browser

; check and then exit if reader's selected browser is okay
readerNotOkay = 'Yes'
if (strtrim(web_browser,2) ne '') then begin
    message_text = ['Your web_browser reader is currently set to:',web_browser, $
                    'Are you sure you want to change this setting?']
    readerNotOkay = dialog_message(message_text,/question,/default_no, $
                                   title='Web browser Setting')
    readerBaseDir = strmid(web_browser,0,strpos(web_browser,!delimiter,/reverse_search))
endif
if (readerNotOkay eq 'No') then return ; nothing to do

; let user select select a browser
if n_elements(group_leader) gt 0 then begin
    browser = dialog_pickfile(dialog_parent = group_leader,/read, $
                              title="Please select your web browser", $
                              path=readerBaseDir, $
                              file = web_browser)
endif else begin
    browser = dialog_pickfile(/read, title="Please select your web_browser", $
                              path=readerBaseDir, $
                              file = web_browser)
endelse

if ((browser eq '') or (browser eq ' ')) then return

dave_defs.web_browser = browser
pdd=!dave_defaults
ptr_free,pdd
pdd=ptr_new(dave_defs)
save,filename=!defaults_file,pdd

defsysv,'!dave_defaults',pdd

print,"New web browser is ",(*!dave_defaults).web_browser

return
end
;-------------------------------------------------------------------------------
