; $Id$
;###############################################################################
;+
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for SPINS PSD Calibration.
;
; CATEGORY:
;   DAVE Main Tool

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of the DAVETool object
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Oct 2014
;-
;###############################################################################





;===============================================================================
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the SPINSPSDCalibTool.
;
; CATEGORY:
;   SPINS PSD Reduction

; PARAMETERS
;
; KEYWORDS:
;   identifier (in)   - The string identifier of SPINSPSDCalibTool object
;
pro SPINSPSDCalib, identifier=identifier, group_leader=gl, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

;Okay, launch the Main Tool
title = "TAS PSD Calibration"
identifier = IDLITSYS_CREATETOOL("SPINSPSDCalibMain", name="Preferences" $
  ,title=title $ ;  ,/debug
  ,dimensions=[650,550] $
  ,USER_INTERFACE="SPINSPSDCalib Main Interface" $
  )

oSystem = oDaveTool->GetSystem()
oSPINSPSDTool = oSystem->GetByIdentifier(identifier)

; Make widget hierarchy with this tool a child of the DAVETool
oSPINSPSDUI = oSPINSPSDTool->GetUI()
oSPINSPSDUI->GetProperty, group_leader=wSPINSPSDTLB
widget_control, wSPINSPSDTLB, group_leader=gl

; Set system preferences
oSPINSPSDTool->SetProperty, DAVETool=oDAVETool $
  ,data_directory=dataDir $
  ,working_directory=workDir $
  ,name = 'Preferences'  ; b/c want the property sheet in main window to have this label
if (obj_valid(oSPINSPSDTool)) then  oSPINSPSDTool->InitPreferences

end
