pro davemenu
compile_opt idl2

xmlfile = file_which('davemenus.xml')
doc = OBJ_NEW('IDLffXMLDOMDocument', FILENAME=xmlfile)

foldList = doc->GetElementsByTagName("folder")
nFold = foldList->GetLength()

i = 0
while (nFold-- gt 0) do begin
   folder = foldList->Item(i++)
   attributeList = folder->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'IDENTIFIER': identifier = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor
      
      print,identifier,' : ',etc
      print,'----------------------'
      
   endif
endwhile


menuList = doc->GetElementsByTagName("menu")
nMenu = menuList->GetLength()

i = 0
while (nMenu-- gt 0) do begin
   menu = menuList->Item(i++)
   attributeList = menu->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      types = ''
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'NAME': name = attValue
            'CLASS': class = attValue
            'TYPES': types = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor
      
      print,name,' : ',class,' : ',etc
      
      if (strlen(types) gt 0) then begin
         print, 'types: ',types
      endif
      print,'----------------------'
      
   endif
endwhile

obj_destroy, doc
end
