function HKLnorm,HKL,latparm=latparm

;calculates the vector norm of HKL = [h,k,l] in inverse angstrom

if n_elements(latparm) eq 0 then latparm=[2*!pi,2*!pi,2*!pi,90.,90.,90.]

a = latparm[0]
b = latparm[1]
c = latparm[2]
al = latparm[3]*!dtor
be = latparm[4]*!dtor
ga = latparm[5]*!dtor

V = a*b*c*sqrt(1+2*cos(al)*cos(be)*cos(ga)-cos(al)^2-cos(be)^2-cos(ga)^2)
; convert to reciprocal lattice
ar = 2*!pi*b*c*sin(al)/V
br = 2*!pi*c*a*sin(be)/V
cr = 2*!pi*a*b*sin(ga)/V
alr = acos( (cos(be)*cos(ga)-cos(al))/abs(sin(be)*sin(ga)) )
ber = acos( (cos(ga)*cos(al)-cos(be))/abs(sin(ga)*sin(al)) )
gar = acos( (cos(al)*cos(be)-cos(ga))/abs(sin(al)*sin(be)) )
g = [[ar^2,ar*br*cos(gar),ar*cr*cos(ber)] $
    ,[ar*br*cos(gar),br^2,br*cr*cos(alr)] $
    ,[ar*cr*cos(ber),br*cr*cos(alr),cr^2]]
tmp=sqrt(HKL##chop(g)##transpose(HKL))
return,tmp[0]

end