; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEsrvHelp
;
; PURPOSE:
;   This file implements an operation (as a service) that can launch
;   help information based on a given keyword that is passed to
;   it. Simply extend IDLitsrvHelp class.
;
; CATEGORY:
;   DAVE Main Tool
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Dec 2006
;-
;###############################################################################


;===============================================================================
; DAVEopHelp::init
; 
; PURPOSE:
;   Class initialization method
;
; PARAMETERS
;
; KEYWORDS:
;


;---------------------------------------------------------------------------
; Arguments:
;   Tool: Object reference to the current tool.
;
;   Keyword: The keyword for which help is desired.
;
; Keywords:
;   None.
;
;===============================================================================
; DAVEopHelp::doAction
; 
; PURPOSE:
;   For the given keyword, locate the associated topic to be displayed
;   from an XML file and then launch the 'HELP' UI service to display
;   help on that topic.
;
; PARAMETER:
;   oTool   - The object ref of the tool from which this request originated
;
;   keyword -  The keyword for which help is desired.
;
; KEYWORDS:
;
pro DAVEsrvHelp::HelpTopic, oTool, keyword

    compile_opt idl2, hidden

    if (~OBJ_VALID(self._oXML)) then begin
        self._oXML = OBJ_NEW('IDLitXMLHelp')
    endif

;    if (!HELP_PATH ne '') then begin
;        ; Find all files ending in *help.xml. Sure hope they're ours.
;        helpPath = STRSPLIT(!HELP_PATH, PATH_SEP(/SEARCH_PATH), /EXTRACT)
;        xmlFile = FILE_SEARCH(helpPath + PATH_SEP()+'*help.xml', COUNT=nmatch)
;    endif else begin
;        ; If no help path, try to look under the IDL main directory.
;        xmlFile = FILEPATH('idlithelp.xml', SUBDIRECTORY = ['help'])
;        nmatch = 1
;    endelse

    xmlFile = !DAVE_HELP_DIR+'davehelp1.xml'
    nmatch = 1

    for i=0,nmatch-1 do begin
        if (~FILE_TEST(xmlFile[i], /READ)) then begin
            self->ErrorMessage, $
                [IDLitLangCatQuery('Error:Framework:CannotFindHelpFile'), xmlFile[i]], $
                SEVERITY=2
            return
        endif
        result = self._oXML->_FindKeyword(xmlFile[i], keyword)
        if (result[0] ne '') then $
            break
    endfor

    if (~nmatch || result[0] eq '') then begin
        self->ErrorMessage, $
            [IDLitLangCatQuery('Error:Framework:NoHelpAvailable'), keyword], $
            SEVERITY=1
        return
    endif

    self._keyword = keyword
    if (~PTR_VALID(self._pLinks)) then $
        self._pLinks = PTR_NEW(/ALLOCATE)

    ;; if a book is specified, get its fully qualified path
    if (strtrim(result[2]) ne '') then $
      result[2] = (file_search(!dave_dir,result[2],/fully_qualify_path))[0]

    *self._pLinks = result
    
    viewers = result[0,*]
    topics = result[1,*]
    books = result[2,*]
    haveViewer = (Where(viewers eq 'HTML'))[0]
    if (haveViewer ge 0) then begin
      if (books[haveViewer]) then begin
;        book = books[haveViewer]
;        if (topics[haveViewer]) then begin
;          book = book+'#'+topics[haveViewer]
;        endif
        Online_help, topics[haveViewer], BOOK=books[haveViewer]
        return
      endif
;      book = topics[haveViewer] ? $
;        topics[haveViewer] : books[haveViewer]
;      Online_help, BOOK=book
;      return
    endif


    result = oTool->DoUIService('Help', self)

end


;-------------------------------------------------------------------------
pro DAVEsrvHelp__define

compile_opt idl2

void = {DAVEsrvHelp, $
        inherits IDLitsrvHelp $
       }
end

