; $Id$

pro DAVEopProjectSave::GetProperty, writerTypes=writerTypes, _REF_EXTRA=etc
compile_opt idl2

if (arg_present(writerTypes)) then begin
    writerTypes =  (ptr_valid(self.writerTypes))? (*self.writerTypes) : ''
endif

if(n_elements(etc) gt 0) then $
  self->IDLitopFileSave::GetProperty, _EXTRA=etc

end


pro DAVEopProjectSave::SetProperty, writerTypes=writerTypes, _EXTRA=etc
compile_opt idl2

if (n_elements(writerTypes) gt 0) then begin
    if (ptr_valid(self.writerTypes)) then $
      (*self.writerTypes) = writerTypes $
    else $
      self.writerTypes = ptr_new(writerTypes)
endif

if(n_elements(etc) gt 0) then $
  self->IDLitopFileSave::SetProperty, _EXTRA=etc 

end




;===============================================================================
; DAVEopProjectSave::Cleanup
; 
; PURPOSE:
;   DAVEopFileSave class cleanup
;
pro DAVEopProjectSave::Cleanup
compile_opt idl2

ptr_free, self.writerTypes

; call base class cleanup
self->IDLitopFileSave::Cleanup

end



;===============================================================================
; DAVEopProjectSave::GetFilterList
; 
; PURPOSE:
;   Provide a list of file filters (extensions) that should be handled
;   by the current operation. Method is intended to be called by the
;   UI Service which launches the file selection dialog.
;
; PARAMETERS:
;
; KEYWORDS:
;   count [out] - The number of filter groups (one group per reader
;                 which may actually contain more than one filter)
;
; RETURN VALUE:
;    If successful, an array of reader name/filter(s) pairs
;    If unsuccessful, an empty string.
;
function DAVEopProjectSave::GetFilterList, COUNT=count
compile_opt idl2

oTool = self->GetTool()
oWriteFile = oTool->GetService("WRITE_FILE")
if(not obj_valid(oWriteFile))then begin
    count = 0
    return,''
endif

self->GetProperty,writerTypes=writerTypes

return, oWriteFile->GetFilterListByType(writerTypes,COUNT=count)

end


;---------------------------------------------------------------------------
; Definition
;---------------------------------------------------------------------------
; Purpose:
;   Class definition.
;
pro DAVEopProjectSave__define
compile_opt idl2

struc = {DAVEopProjectSave $
         ,writerTypes:ptr_new('') $ ; names of valid writers to be used
         ,inherits IDLitopFileSave $
        }

end

