; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEopProjectOpen
;
; PURPOSE:
;   An operation class for initiating a project open
;   action within DAVE.
;
; CATEGORY:
;   DAVE Main Tool
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; June 2004
;-
;###############################################################################


;===============================================================================
; DAVEopProjectOpen::GetFilterList
; 
; PURPOSE:
;   Provide a list of file filters (extensions) that should be handled
;   by the current operation. Method is intended to be called by the
;   UI Service which launches the file selection dialog.
;
; PARAMETERS:
;
; KEYWORDS:
;   count [out] - The number of filter groups (one group per reader
;                 which may actually contain more than one filter)
;
; RETURN VALUE:
;    If successful, an array of reader name/filter(s) pairs
;    If unsuccessful, an empty string.
;
function DAVEopProjectOpen::GetFilterList, COUNT=count

   compile_opt idl2, hidden

   oTool = self->GetTool()
   oReadFile = oTool->GetService("READ_FILE")
   if(not obj_valid(oReadFile))then begin
       count = 0
       return,''
   endif

   return, oReadFile->GetFilterListByReaderName('iTools State', COUNT=count)
end


;===============================================================================
; DAVEopProjectOpen__define
; 
; PURPOSE:
;   DAVEopFileOpen class structure definition
;
pro DAVEopProjectOpen__define

    compile_opt idl2, hidden

    struc = {DAVEopProjectOpen, $
        inherits IDLitopFileOpen }

end
