; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEopMenuItem
;
; PURPOSE:
;   This file implements an operation that implements a generic menu
;   item in a tool. Normally a menu item will be associated with an 
;   operation class. However, in some cases we want to associate a menu
;   item with a method of the main tool that owns this operation. The
;   identifier associated with the menu at registration is taken to be
;   the method that is to be executed when the menu is selected.
;
; CATEGORY:
;   DAVE Main Tool
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2005
;-
;###############################################################################


;===============================================================================
; DAVEopMenuItem::init
; 
; PURPOSE:
;   Class initialization method
;
; PARAMETERS
;
; KEYWORDS:
;
function DAVEopMenuItem::Init, _REF_EXTRA=extra
compile_opt idl2

if (self->IDLitOperation::Init(_EXTRA=extra) eq 0) then $
  return, 0

return, 1

end


;===============================================================================
; DAVEopMenuItem::doAction
; 
; PURPOSE:
;   Intantiate an independent application which has been previously
;   registered as a UI Service with the DAVE Main Tool.
;
; PARAMETER:
;   oTool   - The object ref of the tool from which this request originated
;
; KEYWORDS:
;
function DAVEopMenuItem::DoAction, oTool
compile_opt idl2

self->GetProperty, IDENTIFIER=id
method = STRMID(id, STRPOS(id, '/', /REVERSE_SEARCH) + 1)

if (strlen(strtrim(method,2)) lt 1) then begin
   msg = 'No valid method found for this menu!'
   oTool->StatusMessage, msg
   return, obj_new()   
endif

if (~obj_hasmethod(oTool, method)) then begin
   msg = "'"+method+"' is not a valid method of the main tool class!"
   oTool->StatusMessage, msg
   return, obj_new()
endif

; Note: the mothod must be implemented as a function
if (~call_method(method, oTool)) then begin
;   msg = "'"+method+"' was not executed successfully!"
;   oTool->StatusMessage, msg
   return, obj_new()
endif

return, obj_new()

end


;===============================================================================
pro DAVEopMenuItem__define
compile_opt idl2

struc = {DAVEopMenuItem,            $
         inherits IDLitOperation    $
        }

end
