; $Id$

;===============================================================================
; DAVEopFileSave::DoAction
; 
; PURPOSE:
;   Performs the save operation
;
; PARAMETERS
;
; KEYWORDS:
;
function DAVEopFileSave::DoAction, oTool, SUCCESS=success
compile_opt idl2

;; We always want to show the dialog.
self->SetProperty, /SHOW_EXECUTION_UI

; oTool should be valid and the DAVE Main Tool
if (~obj_valid(oTool) || ~obj_isa(oTool,'DAVETOOL')) then return, obj_new()

; Get the selected dataset(s)
oSelections = oTool->GetSelectedData()
void = where(obj_valid(oSelections),cnt)
if (cnt eq 0) then begin
    oTool->StatusMessage, 'No valid data to operate on! Select a dataset from the Data Browser tree.'
    return, obj_new()
endif

;; Locate valid dave1datasets from selection
;validType = 'DAVE1DATASET'
;for i = 0,n_elements(oSelections)-1 do begin
;    oRes = oSelections[i]->GetByType(validType)
;    if (~obj_valid(oRes)) then continue
;    oData = (n_elements(oData) gt 0)? [oData,oSelections[i]] : oSelections[i]
;endfor
;if (n_elements(oData) eq 0) then begin
;    oTool->StatusMessage, 'No valid data to operate on! Select a dataset from the Data Browser tree.'
;    return, obj_new()
;endif

oData = oSelections

for i = 0,n_elements(oData)-1 do begin
    ; Determine default output filename
    oData[i]->GetProperty, name=nameTag, description=desc
    while ((pos = stregex(nameTag,' ')) ne -1) do begin
      ; replace spaces in filename with _
      strput, nameTag,'_',pos
    endwhile
    self->SetProperty, filename=nameTag
    
    ; Save the file
    success = self->_Save(oData[i])

    ; Send status message
    self->GetProperty, filename=filename
    if (success eq 1) then $
       oTool->StatusMessage, 'Data written to '+filename $
    else $
       oTool->StatusMessage, 'Data was NOT saved!'
 endfor

;; No undo/redo
return, obj_new()

end




;===============================================================================
; DAVEopFileSave::_Save, oTool
; 
; PURPOSE:
;   Performs the save operation
;
; PARAMETERS
;
; KEYWORDS:
;
function DAVEopFileSave::_Save, oData
compile_opt idl2

;; Do we have our File Writer service?
oTool = self->GetTool()
oWriteFile = oTool->GetService("WRITE_FILE")
if (not obj_valid(oWriteFile)) then begin
    self->ErrorMessage, $
      [IDLitLangCatQuery('Error:Framework:CannotAccessWriterService')], $
      title=IDLitLangCatQuery('Error:InternalError:Title'), severity=2
    return, 0
endif

self->IDLitOperation::GetProperty, SHOW_EXECUTION_UI=showUI

self->GetProperty, filename=filename
badName = (filename eq '') || $
          STRCMP(filename, 'untitled', 8, /FOLD_CASE)

if (showUI || badName) then begin
    ;; Ask the UI service to present the file selection dialog to the user.
    ;; The caller sets my filename property before returning.
    ;; This should also call my GetFilterList().
    success = oTool->DoUIService('FileSaveAs', self)
    
    if (success eq 0) then return, -1 ; cancel
    
endif

self->GetProperty, filename=filename

;; Write the data through the writer service's writefile() method
;; which is responsible for locating and calling the appropriate
;; writer.
status = oWriteFile->WriteFile(filename, oData)

if (status ne 1) then begin
    self->ErrorMessage, /USE_LAST_ERROR, $
                        title=IDLitLangCatQuery('Error:InternalError:Title'), severity=2, $
                        [IDLitLangCatQuery('Error:Framework:FileWriteError'), $
                         filename]
    return, 0
endif

return, 1                       ; success

end


;===============================================================================
; DAVEopFileSave::SetProperty
; 
; PURPOSE:
;   Get method for class
;
; PARAMETERS
;
; KEYWORDS:
;
pro DAVEopFileSave::GetProperty, writerTypes=writerTypes, _REF_EXTRA=etc
compile_opt idl2

if (arg_present(writerTypes)) then begin
    writerTypes =  (ptr_valid(self.writerTypes))? (*self.writerTypes) : ''
endif

if(n_elements(etc) gt 0) then $
  self->IDLitopFileSave::GetProperty, _EXTRA=etc

end


;===============================================================================
; DAVEopFileSave::SetProperty
; 
; PURPOSE:
;   Set method for class
;
; PARAMETERS
;
; KEYWORDS:
;
pro DAVEopFileSave::SetProperty, writerTypes=writerTypes, _EXTRA=etc
compile_opt idl2

if (n_elements(writerTypes) gt 0) then begin
    if (ptr_valid(self.writerTypes)) then $
      (*self.writerTypes) = writerTypes $
    else $
      self.writerTypes = ptr_new(writerTypes)
endif

if(n_elements(etc) gt 0) then $
  self->IDLitopFileSave::SetProperty, _EXTRA=etc 

end




;===============================================================================
; DAVEopFileSave::Cleanup
; 
; PURPOSE:
;   DAVEopFileSave class cleanup
;
pro DAVEopFileSave::Cleanup
compile_opt idl2

ptr_free, self.writerTypes

; call base class cleanup
self->IDLitopFileSave::Cleanup

end



;===============================================================================
; DAVEopFileSave::GetFilterList
; 
; PURPOSE:
;   Provide a list of file filters (extensions) that should be handled
;   by the current operation. Method is intended to be called by the
;   UI Service which launches the file selection dialog.
;
; PARAMETERS:
;
; KEYWORDS:
;   count [out] - The number of filter groups (one group per reader
;                 which may actually contain more than one filter)
;
; RETURN VALUE:
;    If successful, an array of reader name/filter(s) pairs
;    If unsuccessful, an empty string.
;
function DAVEopFileSave::GetFilterList, COUNT=count
compile_opt idl2

oTool = self->GetTool()
oWriteFile = oTool->GetService("WRITE_FILE")
if(not obj_valid(oWriteFile))then begin
    count = 0
    return,''
endif

self->GetProperty,writerTypes=writerTypes

return, oWriteFile->GetFilterListByType(writerTypes,COUNT=count)

end


;===============================================================================
; DAVEopFileSave::Init
; 
; PURPOSE:
;   Initialization method for objects of DAVEopFileSave class
;
; PARAMETERS
;
; KEYWORDS:
;
function DAVEopFileSave::Init, _REF_EXTRA=etc
compile_opt idl2

on_error, 2
catch, theError
if (theError ne 0) then begin
    catch, /cancel
    message, /reissue_last
    return, 0
endif

; Default is to show the File Selection dialog,
; so set SHOW_EXECUTION_UI to true.
success = self->IDLitopFileSave::Init(/SHOW_EXECUTION_UI, _EXTRA=etc)

; We always want the File Selection dialog to be shown,
; so don't allow the property to be turned on/off.
self->SetPropertyAttribute, 'SHOW_EXECUTION_UI', /HIDE

return, success

end
;---------------------------------------------------------------------------



;---------------------------------------------------------------------------
; Definition
;---------------------------------------------------------------------------
; Purpose:
;   Class definition.
;
pro DAVEopFileSave__define
compile_opt idl2

struc = {DAVEopFileSave $
         ,writerTypes:ptr_new('') $ ; names of valid writers to be used
         ,inherits IDLitopFileSave $
        }

end

