; $Id$
;
; Copyright (c) 2000-2007, ITT Visual Information Solutions. All
;       rights reserved. Unauthorized reproduction is prohibited.
;----------------------------------------------------------------------------
;===============================================================================
; Richard Tumanjong Azuah
; NCNR, NIST
;
; Based on IDLitopFileExit
; DIFF to IDLitopFileExit
; - Use the tool's prompt property to determine whether to display a confirmation 
;   dialog message before deleting the tool.
;
;===============================================================================
;+
; CLASS_NAME:
;   DAVEopFileExit
;
; PURPOSE:
;   This file implements the generic IDL Tool object that
;   implements the actions performed when a property sheet is used.
;
; CATEGORY:
;   IDL Tools
;
; SUPERCLASSES:
;
; SUBCLASSES:
;
; CREATION:
;   See DAVEopFileExit::Init
;
; METHODS:
;   This class has the following methods:
;
;   DAVEopFileExit::Init
;   DAVEopFileExit::DoAction
;
; INTERFACES:
; IIDLProperty
;-
;;---------------------------------------------------------------------------
;; Lifecycle Routines
;;---------------------------------------------------------------------------
;; DAVEopFileExit::Init
;;
;; Purpose:
;; The constructor of the DAVEopFileExit object.
;;
;; Parameters:
;; None.
;;
;-------------------------------------------------------------------------
function DAVEopFileExit::Init, _extra=_extra
compile_opt idl2

return, self->IDLitOperation::Init(_extra=_extra)
end

;;---------------------------------------------------------------------------
;; DAVEopFileExit::DoAction
;;
;; Purpose:
;;
;; Parameters:
;; None.
;;
;-------------------------------------------------------------------------
function DAVEopFileExit::DoAction, oTool
compile_opt idl2

promptTitle=''
promptDesc=''
oTool->GetProperty, prompt=promptFlag, prmptDesc=promptDesc, prmptTitle=promptTitle
if ((n_elements(promptFlag) gt 0) && promptFlag eq 1) then begin
    ;self->GetProperty, description=description
    
    if (strcmp(promptTitle,'')) then promptTitle='Delete Window?'
    if (strcmp(promptDesc,'')) then promptDesc='Window'
    msg = ["Are you sure you want to delete","this "+promptDesc+"?"]
    status = oTool->PromptUserYesNo(msg,answer,title=promptTitle)
    if (status eq 0) then return, obj_new()
    if (answer eq 0) then return, obj_new()       
endif

;; Now okay to proceed with delete action
oShutdown = oTool->GetService("SHUTDOWN")

oSrvMacro = oTool->GetService('MACROS')
if OBJ_VALID(oSrvMacro) then begin
    ; need to explicitly add this operation since after shutdown
    ; the tool is invalid
    oSrvMacro->GetProperty, CURRENT_NAME=currentName
    oSrvMacro->PasteMacroOperation, self, currentName
endif

if(~obj_valid(oShutdown))then begin
    oTool->ErrorMessage, title=IDLitLangCatQuery('Error:InternalError:Title'), $
  [ IDLitLangCatQuery('Error:Framework:CannotAccessShutdown'), $
  IDLitLangCatQuery('Error:Framework:ForceShutdown')], severity=2
    obj_destroy,self
    return,obj_new()
endif
return, oTool->DoAction(oShutdown->GetFullIdentifier())

end


;;-------------------------------------------------------------------------
;; Definition
pro DAVEopFileExit__define
    compile_opt hidden, idl2
    struc = {DAVEopFileExit, inherits IDLitOperation}

end

