; $Id$
;###############################################################################
;
; NAME:
;  RAINS_DISP_EQUATION
;
; PURPOSE:
;  Displays a png file that shows the definition of the file.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;+
; NAME:
;       RAINS_DISP_EQUATION
;
; PURPOSE:
;
;		Displays a PNG image of the equation for a particular model.
;
;
; AUTHOR:
;
;       Robert M. Dimeo, Ph.D.
;		NIST Center for Neutron Research
;       100 Bureau Drive
;		Gaithersburg, MD 20899
;       Phone: (301) 975-8135
;       E-mail: robert.dimeo@nist.gov
;       http://www.ncnr.nist.gov/staff/dimeo
;
; CATEGORY:
;
;       Data analysis, DAVE, RAINS application
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro rde_event,event
uname = widget_info(event.id,/uname)
case uname of
'QUIT':	$
	begin
		widget_control,event.top,get_uvalue = state
		tvlct,state.ri,state.gi,state.bi	; restore the colors
		widget_control,event.top,/destroy
	end
'PRINT':	$
	begin
		widget_control,event.top,get_uvalue = state
		keywords =	PSConfig(Cancel=cancelled,group_leader = event.top,$
					color = 0, directory = state.workdir)
		if cancelled then return
		thisDevice = !D.Name
		Set_Plot, 'PS'
		Device, _Extra=keywords
		tvimage,state.image
		Device, /Close_File
		Set_Plot, thisDevice
	end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro rains_disp_equation,	group_leader = group_leader,		$
							png_image = png_image

if n_elements(group_leader) eq 0 then return
if n_elements(png_image) eq 0 then return
widget_control,group_leader,get_uvalue = orefine
ret = orefine->get(workdir = workdir)
register_name = 'rde'
if xregistered(register_name) then return
tvlct,ri,gi,bi,/get	; get the colors coming into the program
image = read_png(png_image,r,g,b)
si = size(image)
tvlct,r,g,b
device,get_screen_size = ss

tlb = widget_base(/col,title = 'Equation viewer',tlb_frame_attr = 9, $
	group_leader = group_leader,/floating)
win = widget_draw(tlb,xsize = si[1],ysize = si[2],/scroll,	$
	y_scroll_size = si[2] < fix(0.8*ss[1]),	$
	x_scroll_size = si[1] < fix(0.8*ss[0])	)
rowbase = widget_base(tlb,/row)
void = widget_button(rowbase,value = 'Print to PS file',uname = 'PRINT')
void = widget_button(rowbase,value = 'Dismiss',uname = 'QUIT')
centertlb,tlb
widget_control,tlb,/realize
widget_control,win,get_value = winvis
wset,winvis
tvimage,image
state = {ri:ri,gi:gi,bi:bi,workdir:workdir,image:image}
widget_control,tlb,set_uvalue = state
xmanager,register_name,tlb,/no_block,event_handler = 'rde_event'
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;