; $Id$
;###############################################################################
;
; NAME:
;  RAFINS_FILE_INFO
;
; PURPOSE:
;  UI that displays the treatment of the current file.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro rafins_file_info_event,event
uname = widget_info(event.id,/uname)
case uname of
'QUIT':	$
	begin
		widget_control,event.top,get_uvalue = state
		if state.modal eq 0 then begin
			p_info =	{	RAFINS_FILE_INFO_EVENT,	$
							id:state.notify_ids[0],		$
							top:state.notify_ids[1],	$
							handler:0L						$
						}

			if widget_info(state.notify_ids[0],/valid_id) then $
			widget_control,state.notify_ids[0],send_event = p_info
		endif
		widget_control,event.top,/destroy
	end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro rafins_file_info,	info,							$
						group_leader = group_leader,	$
						notify_ids = notify_ids,		$
						title = title,					$
						modal = modal
if n_elements(modal) eq 0 then modal = 0
register_name = 'rafins_file_info'
;if xregistered(register_name) then return
nlines = n_elements(info)
width = max(strlen(info))
if n_elements(title) eq 0 then title = 'DAVE file information'
tlb = widget_base(group_leader = group_leader,/col,/tlb_frame_attr, $
	title = title,modal = modal)

text = widget_text(tlb,value = info,xsize = width,ysize = 25,/editable,/scroll)
void = widget_button(tlb,value = 'Dismiss',uname = 'QUIT')
widget_control,tlb,/realize
state = {notify_ids:notify_ids,modal:modal}
widget_control,tlb,set_uvalue = state,/no_copy
xmanager,register_name,tlb,/no_block
end