;$Id$
;###############################################################################
;
; NAME:
;  GET_TEST_MODEL_DATA
;
; PURPOSE:
;
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro get_info_out,event
widget_control,event.top,get_uvalue = pinfo
nx_id = widget_info(event.top,find_by_uname = 'NX')
ny_id = widget_info(event.top,find_by_uname = 'NY')
xlo_id = widget_info(event.top,find_by_uname = 'XLO')
xhi_id = widget_info(event.top,find_by_uname = 'XHI')
ylo_id = widget_info(event.top,find_by_uname = 'YLO')
yhi_id = widget_info(event.top,find_by_uname = 'YHI')
counts_id = widget_info(event.top,find_by_uname = 'COUNTS')
widget_control,nx_id,get_value = nx & nx = fix(nx[0])
widget_control,ny_id,get_value = ny & ny = fix(ny[0])
widget_control,xlo_id,get_value = xlo & xlo = float(xlo[0])
widget_control,xhi_id,get_value = xhi & xhi = float(xhi[0])
widget_control,ylo_id,get_value = ylo & ylo = float(ylo[0])
widget_control,yhi_id,get_value = yhi & yhi = float(yhi[0])
widget_control,counts_id,get_value = counts & counts = fix(counts[0])
(*pinfo).nx = nx
(*pinfo).ny = ny
(*pinfo).xlo = xlo
(*pinfo).xhi = xhi
(*pinfo).ylo = ylo
(*pinfo).yhi = yhi
(*pinfo).counts = counts
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro get_test_model_data_event,event
widget_control,event.top,get_uvalue = pinfo
uname = widget_info(event.id,/uname)
case uname of
'EXIT':	$
	begin
		(*pinfo).cancel = 0
		get_info_out,event
		widget_control,event.top,/destroy
	end
'CANCEL':	$
	begin
		(*pinfo).cancel = 1
		widget_control,event.top,/destroy
	end
'XUNITS':	$
	begin
		(*pinfo).xunits = event.value
	end
else:
endcase

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function get_test_model_data,	group_leader = group_leader,	$
								info = info,					$
								cancel = cancel
if n_elements(info) eq 0 then $
	info = {	cancel:1,		$
				nx:50,			$
				ny:50,			$
				xlo:-10.0,		$
				xhi:10.0,		$
				ylo:0.1,		$
				yhi:2.5,		$
				xunits:'meV',	$
				counts:1e3		}
if n_elements(group_leader) eq 0 then return,info
tlb = widget_base(group_leader = group_leader,/modal,/tlb_frame_attr,title = $
	'Test Data Parameter Entry',/col)
rowbase = lonarr(3)
rowbase[0] = widget_base(tlb,/row)
nx = cw_field(rowbase[0],title = '# x values',value = strtrim(string(info.nx),2),	$
	uname = 'NX',xsize = 3)
xlo = cw_field(rowbase[0],title = 'xlo',value = strtrim(string(info.xlo),2),		$
	uname = 'XLO')
xhi = cw_field(rowbase[0],title = 'xhi',value = strtrim(string(info.xhi),2),		$
	uname = 'XHI')
rowbase[1] = widget_base(tlb,/row)
ny = cw_field(rowbase[1],title = '# y values',value = strtrim(string(info.ny),2),	$
	uname = 'NY',xsize = 3)
ylo = cw_field(rowbase[1],title = 'ylo',value = strtrim(string(info.ylo),2),		$
	uname = 'YLO')
yhi = cw_field(rowbase[1],title = 'yhi',value = strtrim(string(info.yhi),2),		$
	uname = 'YHI')
rowbase[2] = widget_base(tlb,/row)
counts = cw_field(rowbase[2],title = 'counts',value = strtrim(string(info.counts),2),	$
	uname = 'COUNTS')
names = ['meV','ueV']
void = cw_bgroup(rowbase[2],names,uname = 'XUNITS',/exclusive,/return_name, $
	set_value = 0,/row)

void = widget_button(rowbase[2],value = 'CANCEL',uname = 'CANCEL')
void = widget_button(rowbase[2],value = 'EXIT',uname = 'EXIT')
centertlb,tlb
widget_control,tlb,/realize

pinfo = ptr_new(info,/no_copy)
widget_control,tlb,set_uvalue = pinfo
register_name = 'get_test_model_data'
xmanager,register_name,tlb

info = *pinfo
cancel = info.cancel
ptr_free,pinfo
return,info
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;