; $Id$
;
;###############################################################################
;
; NAME:
;  TABLE_LOOKUP__DEFINE
;
; PURPOSE:
;  Object class definition for tables of values used for looking
;  up functions in fitting data in RAINS and PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, PAN, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; Simple object class to read in and manipulate the table lookup data.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro table_lookup::cleanup
ptr_free,self.xnl_ptr,self.xnl_lptr,self.ktable_ptr
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function table_lookup::load_xnl_table
filename = 'xnl.txt'
file = (file_search(!DAVE_DIR,filename,/fully_qualify_path))[0]
;if file_which(filename) eq '' then begin
;  file = filename
;endif else begin
;  file = file_which(filename)
;endelse
nvalues = 100
openr,lun,file,/get_lun

nbig = 100
xnl = dblarr(nbig)
l = intarr(nbig)
xx = 0.0
ll = 0
dummy = ''
for i = 0,nbig-1 do begin
  readf,lun,dummy
  reads,dummy, ll,xx
  xnl[i] = double(xx)
  l[i] = fix(ll)
endfor

free_lun,lun,/force
*self.xnl_ptr = xnl
*self.xnl_lptr = l
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function table_lookup::load_ktable
file = !DAVE_AUXILIARY_DIR+'kohlrauschtable.txt'
;if file_which('kohlrauschtable.txt') eq '' then begin
;  file = 'kohlrauschtable.txt'
;endif else begin
;  file = file_which('kohlrauschtable.txt')
;endelse
openr, lun, file, /get_lun
   readf,lun,npts,nb,nt
   yout = dblarr(npts+1,nb+1,nt+1)
   readf, lun, yout
free_lun, lun
*self.ktable_ptr = yout
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function table_lookup::get_xnl,  xnl = xnl,   $
                 l = l

if n_elements(*self.xnl_ptr) eq 0 then begin
   ret = self->load_xnl_table()
endif
xnl = *self.xnl_ptr
l = *self.xnl_lptr
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function table_lookup::is_ktable_loaded,  loaded = loaded
loaded = (n_elements(*self.ktable_ptr) ne 0)
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function table_lookup::get_ktable,  ktable_ptr = ktable_ptr, $
                  msg = msg
if n_elements(*self.ktable_ptr) eq 0 then begin
   ret = self->load_ktable()
endif
ktable_ptr = self.ktable_ptr
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function table_lookup::init
self.xnl_ptr = ptr_new(/allocate_heap)
self.xnl_lptr = ptr_new(/allocate_heap)
self.ktable_ptr = ptr_new(/allocate_heap)
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro table_lookup__define
   define =   { table_lookup,      $
           ktable_ptr:ptr_new(), $
           xnl_ptr:ptr_new(),    $
           xnl_lptr:ptr_new()    }
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;