; $Id$
;###############################################################################
;
; NAME:
;  REFINE_FUNCTION_CONT__DEFINE
;
; PURPOSE:
;  Object class definition for a container object that can contain
;  multiple REFINE_FUNCTION objects.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; REFINE_FUNCTION_CONT__DEFINE.PRO
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::cleanup
self->IDL_CONTAINER::cleanup
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::init
; Initialize superclass
self.wid = 0L
self.chisq = (-1L)
if not self->IDL_CONTAINER::Init() then return,0
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::display_contour,_Extra = extra
ret = self->evaluate(zvalues = zvalues)
oall = self->get(/all)
nobj = self->count()
xindex = extra.xindex
yindex = extra.yindex
if nobj gt 0 then begin
   position = extra.position
   ret = oall[0]->get(xvalues = x,yvalues = y)
   if extra.autoscale eq 1 then begin
     xrange = [min(x),max(x)]
     yrange = [min(y),max(y)]
   endif else begin
     xrange = extra.xrange
     yrange = extra.yrange
   endelse
   disp = (zvalues[xindex,*])[*,yindex]
   disp_qty = alog10(abs(min(disp))+0.001+disp)
   contour,bytscl(disp_qty),x[xindex],y[yindex],xrange = xrange, $
     yrange = yrange,xstyle = 5,ystyle = 4,position = position, $
     nlevels = extra.nlevels,/noerase
endif
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::overplot,group,_Extra = extra
ret = self->evaluate(zvalues = zvalues)
z = zvalues[*,group]

oall = self->get(/all)
nobj = self->count()
if nobj gt 0 then begin
   ret = oall[0]->get(xvalues = x,yvalues = y)
   xrange = extra.xrange
   yrange = extra.yrange
   plot,x,z,psym = 0,thick = 2.0,xrange = xrange,yrange = yrange, $
     /noerase,xstyle = 5,ystyle = 5
endif
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::setwid,wid = wid
self.wid = wid
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getwid,wid = wid
wid = self.wid
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getstep
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(step = step)
  if i eq 0 then stepout = step else stepout = [stepout,step]
endfor
return,stepout
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::drawComponents,_Extra = extra
nfuncs = self->count()
if nfuncs eq 0 then return
oall = self->get(/all)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(xvalues = xvalues, yvalues = yvalues,name = name)
  if name ne 'pan_delta' then oplot,xvalues,yvalues,_Extra = extra
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::setstep,newstep
if n_params() eq 0 then return
nfuncs = self->count()
if nfuncs eq 0 then return

oall = self->get(/all)
count = 0
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(step = oldStep)
  nstep = n_elements(oldStep)
  ret = oall[i]->set(step = newStep[count:count+nstep-1])
  count = count + nstep
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getExpr
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(expr = expr)
  if i eq 0 then exprout = expr else exprout = [exprout,expr]
endfor
return,exprout
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getfixed
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(fixed = fixed)
  if i eq 0 then fixedout = fixed else fixedout = [fixedout,fixed]
endfor
return,fixedout
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::setfixed,newfixed
if n_params() eq 0 then return
nfuncs = self->count()
if nfuncs eq 0 then return

oall = self->get(/all)
count = 0
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(fixed = oldFixed)
  nfixed = n_elements(oldFixed)
  ret = oall[i]->set(fixed = newfixed[count:count+nfixed-1])
  count = count + nfixed
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::gettied
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(tied = tied)
  if i eq 0 then tieddout = tied else tieddout = [tieddout,tied]
endfor
return,tieddout
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::settied,newtied
if n_params() eq 0 then return
nfuncs = self->count()
if nfuncs eq 0 then return

oall = self->get(/all)
count = 0
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(tied = oldtied)
  ntied = n_elements(oldtied)
  ret = oall[i]->set(tied = newtied[count:count+ntied-1])
  count = count + ntied
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getfixvalues
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(fixvalues = fixvalues)
  if i eq 0 then fixout = fixvalues else fixout = [fixout,fixvalues]
endfor
return,fixout
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::setfixvalues,newfixvalues
if n_params() eq 0 then return
nfuncs = self->count()
if nfuncs eq 0 then return

oall = self->get(/all)
count = 0
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(fixvalues = oldFixvalues)
  nfixed = n_elements(oldFixvalues)
  ret = oall[i]->set($
           fixvalues = newfixvalues[count:count+nfixed-1],/calculate)
  count = count + nfixed
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getchisq
return,self.chisq
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::setchisq,chisq
self.chisq = chisq
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getlowvalues
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(lovalues = lovalues)
  if i eq 0 then lo_out = lovalues else lo_out = [lo_out,lovalues]
endfor
return,lo_out
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::setlowvalues,newlovalues
if n_params() eq 0 then return
nfuncs = self->count()
if nfuncs eq 0 then return

oall = self->get(/all)
count = 0
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(lovalues = oldLovalues)
  nlovalues = n_elements(oldLovalues)
  ret = oall[i]->set(lovalues = newlovalues[count:count+nlovalues-1])
  count = count + nlovalues
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::gethighvalues
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(hivalues = hivalues)
  if i eq 0 then hi_out = hivalues else hi_out = [hi_out,hivalues]
endfor
return,hi_out
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::sethighvalues,newhivalues
if n_params() eq 0 then return
nfuncs = self->count()
if nfuncs eq 0 then return

oall = self->get(/all)
count = 0
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(hivalues = oldhivalues)
  nhivalues = n_elements(oldhivalues)
  ret = oall[i]->set(hivalues = newhivalues[count:count+nhivalues-1])
  count = count + nhivalues
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getlow
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(low = low)
  if i eq 0 then low_out = low else low_out = [low_out,low]
endfor
return,low_out
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::setlow,newlow
if n_params() eq 0 then return
nfuncs = self->count()
if nfuncs eq 0 then return

oall = self->get(/all)
count = 0
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(low = oldlow)
  nlow = n_elements(oldlow)
  ret = oall[i]->set(low = newlow[count:count+nlow-1])
  count = count + nlow
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::gethigh
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(high = high)
  if i eq 0 then high_out = high else high_out = [high_out,high]
endfor
return,high_out
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::sethigh,newhigh
if n_params() eq 0 then return
nfuncs = self->count()
if nfuncs eq 0 then return

oall = self->get(/all)
count = 0
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(high = oldHigh)
  nhigh = n_elements(oldHigh)
  ret = oall[i]->set(high = newhigh[count:count+nhigh-1])
  count = count + nhigh
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getparms
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)

for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(params = params)
  if i eq 0 then parmout = params else parmout = [parmout,params]
endfor
return,parmout
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getParmError
nfuncs = self->count()
if nfuncs eq 0 then return,-1L
oall = self->get(/all)

for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(prms_err = parmError)
  if i eq 0 then errout = parmError else errout = [errout,parmError]
endfor
return,errout
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::setparmError,newError
if n_params() eq 0 then return
nfuncs = self->count()
if nfuncs eq 0 then return

oall = self->get(/all)
count = 0
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(prms_err = oldError)
  nparms = n_elements(oldError)
  ret = oall[i]->set(prms_err = newError[count:count+nparms-1],/calculate)
  count = count + nparms
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::setparms,newparms
if n_params() eq 0 then return
nfuncs = self->count()
if nfuncs eq 0 then return

oall = self->get(/all)
count = 0
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(params = oldParms)
  nparms = n_elements(oldParms)
  ret = oall[i]->set(params = newparms[count:count+nparms-1],/calculate)
  count = count + nparms
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::display_image,_Extra = extra
count = self->count()
if count eq 0 then begin
   return,0
endif
oall=self->get(/all)
for i = 0,count-1 do begin
   ret = oall[i]->get(zvalues = zvalues)
   if i eq 0 then zdisplay = zvalues else zdisplay = zdisplay+zvalues
endfor
ret = oall[0]->get(xvalues = xvalues,yvalues = yvalues)
pos = [0.15,0.15,0.9,0.9]
tvimage,bytscl(alog10(zdisplay)),position = pos
xrange = [min(xvalues),max(xvalues)]
yrange = [min(yvalues),max(yvalues)]
plot,xvalues,yvalues,xrange = xrange,yrange = yrange,/nodata,/noerase, $
   position = pos
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::draw,noerase = noerase,overplot = overplot,resPtr = resPtr
nfuncs = self->count()
if nfuncs eq 0 then return
oall = self->get(/all)
ret = oall[0]->get(xvalues = xvalues)
if (n_elements(resPtr) ne 0) and (n_elements(*resPtr) ne 0) then begin
  self->evaluate,xvalues,yout = yvalues,resPtr = resPtr
endif else begin
  self->evaluate,xvalues,yout = yvalues
endelse
if n_elements(noerase) eq 0 then noerase = 0
if n_elements(overplot) eq 0 then overplot = 0
if overplot ne 0 then begin
  oplot,xvalues,yvalues,linestyle = 2
endif else begin
  plot,xvalues,yvalues,linestyle = 2,noerase = noerase
endelse
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::setxvalues,x,resPtr = resPtr,yout = yout, $
               rlimit = rlimit, $
               _Extra = extra


nfuncs = self->count()
yout = 0.0
delta = 0   ; no delta function present
deltaloc = -1L ; index/location for delta function
if nfuncs ne 0 then begin
  oall = self->get(/all)
  for i = 0,nfuncs-1 do begin
    ret = oall[i]->set(xvalues = x,/calculate)
  endfor
endif
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::evaluate,zvalues = zvalues
;if n_elements(*resPtr) ne 0 then resln = res
nfuncs = self->count()
zvalues = 0.0

if nfuncs ne 0 then begin
  oall = self->get(/all)
  for i = 0,nfuncs-1 do begin
    ret = oall[i]->get(zvalues = yout)
   zvalues = zvalues + yout
  endfor
endif else begin
   return,0
endelse
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getcurvename,index
; This function returns the curve name given an index into the
; long parameter array.
nfuncs = self->count()
if nfuncs eq 0 then return,''

names = strarr(nfuncs)
oall = self->get(/all)
nparms = intarr(nfuncs)
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(name = name,params = params)
  if i eq 0 then begin
    nparms = n_elements(params)
    names = name
  endif else begin
     nparms = [nparms,n_elements(params)]
     names = [names,name]
  endelse
endfor

totparms = total(nparms)
start = intarr(nfuncs)
finish = intarr(nfuncs)

for i = 0,nfuncs-1 do begin
  if i eq 0 then start[i] = 0 else start[i] = finish[i-1]+1
  finish[i] = start[i] + nparms[i] - 1
  if (index ge start[i]) and (index le finish[i]) then curveName = names[i]
endfor

return,curveName
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getnames
  nfuncs = self->count()
  if nfuncs eq 0 then begin
    names = ""
  endif else begin
    oall = self->get(/all)
    names = strarr(nfuncs)
    for i = 0,nfuncs-1 do begin
      ret = oall[i]->get(name = name)
      names[i] = name
    endfor
  endelse
return,names
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getparmnames

  nfuncs = self->count()
  if nfuncs eq 0 then begin
    names = ""
    return,-1L
  endif else begin
    oall = self->get(/all)
    names = strarr(nfuncs)
    for i = 0,nfuncs-1 do begin
      ret = oall[i]->get(parmnames = pn)
      if i eq 0 then parmnames = pn else parmnames = [parmnames,pn]
    endfor
  endelse
  return,parmnames
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::getCanDraw

  nfuncs = self->count()
  if nfuncs eq 0 then begin
    return,-1L
  endif else begin
    oall = self->get(/all)
    names = strarr(nfuncs)
    for i = 0,nfuncs-1 do begin
      ret = oall[i]->get(canDraw = thisDraw)
      if i eq 0 then canDraw = thisDraw else canDraw = [canDraw,thisDraw]
    endfor
  endelse
  return,canDraw
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont::displayparms,output = output
nfuncs = self->count()
if nfuncs eq 0 then return
oall = self->get(/all)
parms = self->getparms()
sigma = self->getparmerror()
count = 0
format = '(e12.3)'
for i = 0,nfuncs-1 do begin
  ret = oall[i]->get(parmnames = pn,name = name,expr = expr)
  name = strmid(name,4)
  nparms = n_elements(pn)
  thisLine = '-----------------'
  if i eq 0 then output = thisLine else output = [output,thisLine]
  output = [output,'Curve '+strtrim(string(i+1),2)+': '+STRUPCASE(name)]
  if expr ne '' then output = [output,expr]
  for j = 0,nparms-1 do begin
    if n_elements(sigma) eq n_elements(parms) then begin
      strout = '#'+strtrim(string(count),2)+': '+ $
                strtrim(string(pn[j]),2)+': '+ $
                strtrim(string(parms[count],format = format),2)+ $
               ' +/- '+strtrim(string(sigma[count],format = format),2)
      output = [output,strout]
    endif else begin
      strout = strtrim('#'+string(count)+':',2)+string(pn[j])+':'+string(parms[count])
      output = [output,strout]
    endelse
    count = count+1
  endfor
endfor
chiFormat = '(f10.3)'
strout = 'Chi-squared: '+strtrim(string(self.chisq,format = chiFormat),2)
output = [output,'']
output = [output,strout]
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_function_cont::createParInfo
nfuncs = self->count()
nparms = n_elements(self->getparms())

parinfo = replicate({fixed:0,limited:[0,0],limits:[0.D,0.D],step:0D,tied:''},nparms)
parinfo.step = self->getstep()
help,self->getfixed()
help,parinfo.fixed

parinfo.fixed = self->getfixed()
parinfo.limited[0] = self->getlow()
parinfo.limited[1] = self->gethigh()
parinfo.limits[0] = self->getlowvalues()
parinfo.limits[1] = self->gethighvalues()

; Now get the tied parameter information out
tied = self->gettied()
if n_elements(tied) gt 1 then begin
 ok = where(tied eq 1,count_tied)
 for i = 1,count_tied-1 do begin
   rhs = 'p['+strtrim(string(ok[0]),2)+']'
   parinfo[ok[i]].tied = rhs
 endfor
endif

return,parinfo
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_function_cont__define

define = {refine_function_cont,  $
          chisq:0.0,      $
          wid:0L,       $
          INHERITS IDL_CONTAINER}
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
