; $Id$
;###############################################################################
;
; NAME:
;  REF_USERFUNCTION
;
; PURPOSE:
;  Implementation of a user-defined model function for use in fitting
;  data in RAINS.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ref_userfunction,x,p,$
                    	parmnames = parmnames, $
                    	expr = expr, $
                    	eval = eval, $
                    	_Extra = extra

parmnames = strarr(n_elements(p))
for i = 0,n_elements(p)-1 do begin
  parmnames[i] = 'p['+strtrim(string(i),2)+']'
endfor
evalExpr = 'yout='+expr
eval = execute(evalExpr,1)
if eval ne 1 then yout = -1
canDraw = 0

return,yout
end