; $Id$
;###############################################################################
;
; NAME:
;  REF_N_FOLD_JUMP_DIFFUSION
;
; PURPOSE:
;  Implementation of the n-fold rotational jump diffusion model for use in fitting
;  data in RAINS.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ref_n_fold_jump_diffusion,xvals,parms,					$
                    	parmnames = parmnames,					$
                    	init_guess = init_guess,				$
                    	qty = qty,								$
                    	step = step,							$
                    	single_parmnames = single_parmnames,	$
                    	multi_parmnames = multi_parmnames,		$
                    	res_ptr = res_ptr,						$
                    	all_y = all_y,							$
                    	xunits = xunits,						$
                    	_Extra = extra
; all_y keyword is relevant for this model
if n_elements(all_y) eq 0 then all_y = 1
nx = extra.nx & ny = extra.ny
x = xvals[0:nx-1] & y = xvals[nx:nx+ny-1]
ux = 1+bytarr(nx) & uy = 1+bytarr(ny)
parmnames =	['N','Tau','Radius', $
			'Intensity:'+strtrim(string(indgen(ny)),2), $
			'Center:'+strtrim(string(indgen(ny)),2)]
single_parmnames = parmnames[0:2]
multi_parmnames = ['Intensity','Center']
if arg_present(step) then begin
	step = dblarr(3+2*extra.ny)
endif
if (n_params() eq 0) or (n_params() eq 1) then begin
	if arg_present(init_guess) then begin
		intensity = max(qty,dimension = 1,index)
		qty_size = size(qty)
		for i = 0,qty_size[2]-1 do begin
			qty_max = max(qty[*,i],index)
			if i eq 0 then index_array = index else $
				index_array = [index_array,index]
		endfor
		center = x[index_array]
		; Guess the 1/2 width at the highest y-value
		; Get the low value first
		amp = max(qty[*,qty_size[2]-2])
		ht = 0.5*amp
		wh_lo = where(abs(amp-ht) le min(abs(amp-ht)) and (x lt 0.0),count_lo)
		x_lo_lim = x[wh_lo[0]]
 		wh_hi = where(abs(amp-ht) le min(abs(amp-ht)) and (x gt 0.0),count_hi)
		x_hi_lim = x[wh_hi[0]]
		fwhm = x_hi_lim - x_lo_lim
		n = 3
		tau = 2.0*0.6528/fwhm
		radius = 1.0
		init_guess = [n,tau,radius,intensity,center]
	endif
  return,-1
endif

N = parms[0]
tau = parms[1]
R = parms[2]

; calculate the structure factors, Ai(Q), for i=1,N-1
nn = 1.0+findgen(n)
rn = 2.0*R*sin(nn*!dpi/N)
un = 1+bytarr(n-1)
uy = 1+bytarr(ny) & ux = 1+bytarr(nx)
summand = (sph_bessel((y#rn),0))	; ny x (n-1)

lmin = 1 & lmax = N-1
al = fltarr(N-1,ny)
lor = 0.0
hbar = 0.6528
intensity = ux#(parms[3:3+ny-1])
center = ux#(parms[3+ny:3+2*ny-1])
center1 = parms[3+ny:3+2*ny-1]

for l = lmin,lmax do begin
	a = (total(summand*(uy#cos(2.0*l*nn*!dpi/N)),2))/N
	al[l-1,*] = transpose(a)
	taul = 0.5*tau/(sin(!dpi*l/N))^2
	gam = hbar/taul
	lor = lor + (ux#a)*(ux#(gam/!dpi)#uy)/((x#uy-center)^2+(ux#gam#uy)^2)
endfor
ao = ux#(1.0-total(al,1))
lineshape = ao*ref_delta(xvals,center1,*res_ptr,nx = nx,ny = ny)+$
            scat_convolute(x,y,lor,*res_ptr) ; RTA - center->center1, scat_convolve->scat_convolute
yout = intensity*lineshape
return,yout
end
