*____________________________________________________________________________
        PROGRAM RQYS
*_____________________________________________________________________________
c
c Calculate R(Q,Y) as FT of R(Q,s)
c
        implicit none
        real*8 Sq,qq,u3,u5,u6,miny,maxy,dy,y,pi,rqy
	real*8 bound,epa,epr,wi(2000),err,rqs
        integer*4 i,j,lw,liw,iw(500),inf,ifail,last,neval,strim
	character*60 ofile,dec*1
	external rqs
        common /parm/ u3,u5,u6,qq,y

c
c Obtain required parameters at run time
c
        u3 = 2.43; u5=2558; u6=215
	write (*,'(T5,A,$)') 'Enter Q, S(Q):'
	read (*,*) qq,sq
        write (*,*) '********** Default Q-Independent Parameters *******'
        write (*,'(A,G10.4,A)') '******* b3 = ',u3,' 1/A^4'
        write (*,'(A,G10.4,A)') '******* b5 = ',u5,' 1/A^8'
        write (*,'(A,G10.4,A)') '******* b6 = ',u6,' 1/A^8'
        write (*,*) '***************************************************'
c
        write (*,'(T5,A,$)') 'Alter Parameters? [N]:'
        read (*,'(A)') dec
        if (dec.EQ.'y' .OR. dec.EQ.'Y') then
           write (*,'(T5,A,$)') 'Enter b3 (1/A^4), b5 (1/A^8) and b6 (1/A^8) :'
           read (*,*) u3,u5,u6
        end if
	write (*,'(T5,A,$)') 'Enter min, max and interval for Y: '
	read (*,*) miny,maxy,dy
	write (*,'(T5,A,$)') 'Give output data file :'
	read (*,'(A)') ofile 
	j = (maxy-miny)/dy+1
	open (unit=10,file=ofile,status='unknown')
	inquire (unit=10,name=ofile)
c
c Set up variables for Infinite integration
c
	pi = 4.0*ATAN(1.0)
        liw = 500
        lw = liw*4
        ifail = 0
        inf = 1
        bound = 0.0
        epa = 0.0000001
        epr = 0.0001
c
c Calculate Function
c
	write (*,*) ' j = ',j
        DO i = 1,j
	   y = miny + dy*(i-1)
           CALL DQAGI(RQS,bound,inf,epa,epr,rqy,err,neval,ifail,liw,lw,last,iw,wi)
	   rqy=rqy*sq/pi
	   write (10,'(3G12.4)') y,rqy,0.01*rqy
        END DO
        j = strim(ofile)
	write (*,*) ' '
	write (*,*) ' Output stored in '//ofile(1:j)
	STOP
	END

*_____________________________________________________________________________
        REAL FUNCTION RQS*8(s)          
*_____________________________________________________________________________
	implicit none
        real*8 s,u3,u5,u6,y,qq,arg
        common /parm/ u3,u5,u6,qq,y
        arg = -(u6/qq**2)*s**6/720
        IF (ABS(arg).LE.60.0) THEN
           RQS = EXP(arg)*COS(Y*s+(u3/qq)*s**3/6-(u5/QQ**3)*s**5/120)
        ELSE
           RQS = 0.0
        END IF
	RETURN
	END
