; $Id$
;###############################################################################
;
; NAME:
;  PAN_QENS
;
; PURPOSE:
;  QENS function for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_qens,x,parms,$
              	parmnames = parmnames, $
              	canDraw = canDraw, $
              	drawMessage = drawMessage, $
                func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
                changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
                resPtr=resPtr, resLimit=rLimit,resolutionRequiredFlag=resolutionRequiredFlag, extConvolFlag=extConvolFlag, $
                _Extra = extra

canDraw = 0
twoDimFlag = 0
resolutionRequiredFlag = 1   ; does function require a resolution function to be defined 0=>No, 1=>Yes

extConvolFlag = 0            ; does function require external convolution? 0=>No, 1=>Yes
                             ; if set to No, it implies a convolution is performed within this function when a resolution function is present
                             ; Also set to No, if you DO NOT wish any external convolution to be performed at all

if n_params() eq 0 then begin
  parmnames = ['total area','eisf','center','FWHM']
  return,-1
endif
drawMessage = strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag function centroid']
drawMessage[2:3] = ['Hold left mouse button down','and drag to change width']
area = parms[0]
eisf = parms[1]
cen = parms[2]
fwhm = parms[3]
gamma = 0.5*fwhm
;elastic = pan_delta(x,[1.0,cen],$
;                    	resPtr = resPtr,$
;                    	rlimit = rlimit)
qens = area*(1.0-eisf)*(gamma/!dpi)/((x-cen)^2+gamma^2)
;ycon = rmd_convolution(x,resPtr,qens,reslimit = rlimit)
;yout = area*(fraction*elastic+(1.0-fraction)*ycon)
;yout = rmd_convol(x,resPtr,qens,pseudo_delta = [[area*eisf,cen]])
yout = pan_convolute(x,resPtr,qens,pseudo_delta = [[area*eisf,cen]])

return,yout
end
