; $Id$
;###############################################################################
;
; NAME:
;  Pan_Polynomial5Bkgd
;
; PURPOSE:
;  Polynomial (up to order 5) background function for fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function Pan_Polynomial5Bkgd,x,parms,$
  parmnames = parmnames, $
  canDraw = canDraw, $
  drawMessage = drawMessage, $
  func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
  changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
  resPtr=resPtr, resLimit=rLimit,resolutionRequiredFlag=resolutionRequiredFlag, extConvolFlag=extConvolFlag, $
  _Extra = extra

  canDraw = 0
  twoDimFlag = 0
  resolutionRequiredFlag = 0   ; does function require a resolution function to be defined 0=>No, 1=>Yes

  extConvolFlag = 0            ; does function require external convolution? 0=>No, 1=>Yes
                               ; if set to No, it implies a convolution is performed within this function when a resolution function is present
                               ; Also set to No, if you DO NOT wish any external convolution to be performed at all

  if N_params() eq 0 then begin
    parmnames = ['Coef0','Coef1','Coef2','Coef3','Coef4','Coef5']
    Return,-1
  endif
  drawMessage = Strarr(4)
  drawMessage[0:1] = ['Hold left mouse button down','and drag to set offset']
  drawMessage[2:3] = ['Hold left mouse button down','and drag to change slope']

  yout = parms[0] + parms[1]*x + parms[2]*x^2 + parms[3]*x^3 + parms[4]*x^4 + parms[5]*x^5
;  np = 5
;  y = x*0.0 + parms[0]
;  for i=1,np do begin
;    if (parms[i] ne 0.0) then y = y + parms[i]*x^i
;  endfor
  
  Return,yout
end