; $Id$
;###############################################################################
;
; NAME:
;  PAN_BASELINE
;
; PURPOSE:
;  Empirical background data assumed to have been measured experimentally and then included 
;  as part of a model used to fit data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_baseline,x,parms,$
                    	parmnames = parmnames, $
                    	canDraw = canDraw, $
                    	drawMessage = drawMessage, $
                    	initParms = initParms, $
                    	func_dataHash = func_dataHash,twoDimFlag=twoDimFlag, $
                    	datSize = datSize, $
                    	workDir=workDir, $
                    	wTLB = wTLB, $
                    	status = status, $
                    	groupNumber = groupNumber, $
                    	changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
                    	resPtr=resPtr, resLimit=rLimit,resolutionRequiredFlag=resolutionRequiredFlag, extConvolFlag=extConvolFlag, $
                    	_Extra = extra




status = 1
canDraw = 0
twoDimFlag = 0
resolutionRequiredFlag = 0   ; does function require a resolution function to be defined 0=>No, 1=>Yes

extConvolFlag = 0            ; does function require external convolution? 0=>No, 1=>Yes
                             ; if set to No, it implies a convolution is performed within this function when a resolution function is present
                             ; Also set to No, if you DO NOT wish any external convolution to be performed at all

if n_params() eq 0 then begin
  parmnames = ['scalefactor','offset','Boxcar Width']
  initParms = [1.0,0.0,1]

  if (isa(func_dataHash,'hash')) then begin
    
    ; check if the hash was previously initialized
    ; if so then no need to do it again
    if (func_dataHash['initialized'] eq 1) then return, -1
    
    filter = '*.dave'
    multiple_files=0
    title='Specify .dave file to load baseline data from'
  
    filename = Dialog_pickfile(title=title,multiple_files=multiple_files,/must_exist, dialog_parent=wTLB $
      ,filter=filter,path=workDir)
  
    if (filename eq '') then begin
      status = 0
      return, 0
    endif
  
    oData = Davedataset(filename=filename)
    if (~obj_valid(oData)) then begin
      status = 0
      msg = ['Unable to restore the selected dataset.','Please load a different baseline dataset!']
      res = Dialog_message(msg,title='Load Baseline dataset',/information,dialog_parent=wTLB)
      Return, 0    
    endif
    
    ; check the size of the baseline is consistent with the data
    oData->GetProperty, ndimensions=nDim, dataDim =datadim, dataValue=func_data, errorValue=func_error, axis1Value=func_x, axis2Value=func_y
    sameSize  = 0
    sameDims = nDim eq datSize[0]
    if (sameDims) then $
      sameSize = (nDim eq 1)? dataDim[0] eq datSize[1] $
                            : dataDim[0] eq datSize[1] && dataDim[1] eq datSize[2]
    if (~sameSize) then begin
      status = 0
      blDimTxt  = "Baseline data: number of dimensions = "+strtrim(string(nDim),2)
      if (nDim eq 1) then blDimTxt = "Baseline data: size = "+strtrim(string(dataDim[0]),2)
      if (nDim eq 2) then blDimTxt = "Baseline data: size = "+strtrim(string(dataDim[0]),2)+"x"+strtrim(string(dataDim[1]),2)
      
      datDimTxt = "Data being fitted: number of dimensions = "+strtrim(string(datSize[0]),2)
      if (datSize[0] eq 1) then datDimTxt = "Data being fitted: size = "+strtrim(string(datSize[1]),2)
      if (datSize[0] eq 2) then datDimTxt = "Data being fitted: size = "+strtrim(string(datSize[1]),2)+"x"+strtrim(string(datSize[2]),2)
      
      msg = "The baseline data is not the same size (dimensions and/or number of points) as the data being fitted."
      msg = [msg,datDimTxt]
      msg = [msg,blDimTxt]
      msg = [msg,'Please load a different baseline dataset!']
      
      res = dialog_message(msg,title='Load Baseline dataset',/information,dialog_parent=wTLB)
      Return, 0
    endif
    
    func_dataHash['baseline_data'] = func_data
    func_dataHash['baseline_error'] = func_error
    func_dataHash['baseline_xval'] = func_x
    func_dataHash['baseline_yval'] = func_y
    func_dataHash['initialized'] = 1
  endif
  
  return,-1
endif
;drawMessage = strarr(4)
;drawMessage[0:1] = ['Hold left mouse button down','and drag function centroid']
;drawMessage[2:3] = ['Hold left mouse button down','and drag to change width']

sf = parms[0]
offset = parms[1]
boxcarwidth = fix(parms[2])

;sig = fwhm/2.354
;area = parms[0]
;cen = parms[1]
;yout = (area/sqrt(2.0*!dpi*sig^2))*exp(-0.5*((x-cen)/sig)^2)

func_data = func_dataHash['baseline_data']
func_error = func_dataHash['baseline_error']
func_x = func_dataHash['baseline_xval']

if (func_data.ndim eq 2) then begin
  ; then extract just the current group
  func_data = func_data[*, groupNumber-1]
  func_error = func_error[*, groupNumber-1]
endif

; if necesar, rebin the function data to the x values of the data to be fitted
sameX = x.Equals(func_x)
if (~sameX) then begin
  ; need to rebin
;  Drebin,func_x,func_data,func_error,x,func_data_reb,func_error_reb,/points,/to_points,err=err,emsg=emsg
;  if (err ne 0) then begin
;    msg = "Problem encounterred when rebinning the data:"
;    msg = [msg,emsg]
;    msg = [msg,'Please load a different baseline dataset!']
;    res = Dialog_message(msg,title='Load Baseline dataset',/information,dialog_parent=wTLB)
;    Return, 0
;  endif
;  func_data = Temporary(func_data_reb)
  
  ; use interpolate instead. It is much better behaved around the edges
  func_data = Interpol(func_data,func_x,x,/nan)
endif

if (boxcarwidth le 1) then boxcarwidth = 1
parms[2] = boxcarwidth
;yout = (boxcarwidth gt 2)? sf*smooth(func_data, boxcarwidth, /NAN) + offset : sf*func_data + offset
yout = sf*smooth(func_data, boxcarwidth, /NAN, /edge_truncate, missing=min(func_data))
       ; /NAN - NANs are treated as missing
       ; missing keyword specifies value to return for elements with no valid point within kernel
       ; /edge_truncate:  If the neighborhood around a point includes a point outside the array, the nearest edge point is used to compute the smoothed result.
return,yout
end
