function Pan_IkedaCarpenterMon2,x,parms,$
  parmnames = parmnames, $
  canDraw = canDraw, $
  drawMessage = drawMessage, $
  initParms = initParms, $
  _Extra = extra
compile_opt idl2

if N_params() eq 0 then begin
  parmnames = ['Scale Factor','Alpha','Beta','R','Sigma Mon1','Ei','Bkgd Const', $
               'Fermi Dist','Mon1 Dist','Mon2 Dist','Time Binwidth','Mon Thickness']
  initParms = [1.0,0.5,0.1,0.2,3.0,500.0,0.0,11.61,11.835,18.50,1.0,0.01]
  Return,-1
endif

canDraw = 0

; the fit parameters are alpha, beta, R, Ei and bc.
; SigmaM1 is determined by a separate fit to Monitor 1 data
; the rest are instrument parameters that should be held fixed
normfactor = parms[0]
alpha = parms[1]      ; IC source parameter
beta = parms[2]       ; IC source parameter
R = parms[3]          ; IC source parameter, 
sigmaM1 = parms[4]    ; Width obtained from fitting a Gaussian to Monitor 1
Ei = parms[5]         ; Incident neutron energy
bc = parms[6]         ; bkgd parameter for flexibility
; Instrument parameters, suggested initial parameters are for ARCS, SNS
lFermi = parms[7]     ;11.61  ; meters - distance moderator to Fermi chopper
lM1 = parms[8]        ;11.835    ; meters
lM2 = parms[9]        ;18.50     ; meters
tBin = parms[10]       ;1.0      ; usec - histogram bin size of the monitor data
mWidth = parms[11]    ;0.01   ; meters == 1 cm - monitor effective thickness along the beam

; expected flight time to M2 due to neutron velocity
vi = Sqrt(Ei/5.22e-6) ; neutron velocity in m/s
TM2 = 1e6*LM2/Vi      ; travel time to M2 in usec, hence 1e6 factor.
; Mean emmision time of neutrons at the source
te = 3/alpha + R/beta
tM2 = TM2 + Te  ; add mean emmision time to travel time to get expected time at monitor

; Now need to evaluate the time distribution of the neutrons at M2
; by scaling the IC parameters by the instrument length at M2

; sigma at m2 rel to sigma at M1
sigmaDet = Sqrt(((mWidth/vi)^2 + tBin^2)/12.0)    ; travel time across monitor + histogram bin width
sigmaM1Cor = Sqrt(sigmaM1^2 - sigmaDet^2)         ; rem sigmaDet before scaling
sigmaM2Cor = sigmaM1Cor* LM2/lM1                  ; Scale sigma from M1 to M2
sigmaM2 = Sqrt(sigmaM2Cor^2 + sigmaDet^2)         ; add sigmaDet

; alpha at M2 rel to source
sf = (lFermi/(lM2-lFermi))
alphaM2 = alpha*sf
betaM2 = beta*sf

dist = bc + normfactor*Icgauss(alphaM2, betaM2, R, sigmaM2, tM2 - x)

return, dist
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; Translated from Python Code obtained from Doug Abernathy
; Based on Jack Carpenter notes from "Elements of Slow Neutron Scattering"
; Modified to take Gaussian sigma directly using recursive formula (DLA)
function ICGauss, alpha, beta, R, sigma, tof
compile_opt idl2

alpha2 = alpha^2
sigma2 = sigma^2
tof2 = tof^2
tofOsigma = tof/sigma
tofOsigma2 = tofOsigma^2

prefactor = alpha/2.0/sqrt(2.0*!pi)/sigma
exp_a = exp(-alpha*tof)
c1 = (1.0 - R)*alpha2
d = alpha - beta
c2 = 2.0*R*(alpha2*beta)/d^3

prefactor_gn = sqrt(!pi*0.5)*sigma
ga0 = prefactor_gn*exp(0.5*alpha2*sigma2)*ERFC((alpha*sigma - tofOsigma)/sqrt(2.0))
gb0 = prefactor_gn*Exp(0.5*beta^2*sigma2)*Erfc((beta*sigma - tofOsigma)/Sqrt(2.0))

ga1 = sigma2*(-alpha*ga0 + exp(alpha*tof - 0.5*tofOsigma2))
ga2 = sigma2*(ga0 - alpha*ga1 - tof*exp(alpha*tof - 0.5*tofOsigma2))

term1 = (c1*tof2 - c2*(1.0 + d*tof + 0.5*d^2*tof2))*exp_a*ga0
term2 = c2*exp(-beta*tof)*gb0
term3 = (2*c1*tof - c2*d*(1.0 + d*tof))*exp_a*ga1
term4 = (c1 - 0.5*c2*d^2)*exp_a*ga2

return, prefactor*(term1 + term2 + term3 + term4)

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


pro TestPan_IkedaCarpenterMon2, dist=dist, plot=plot
compile_opt idl2

parms = [10.0,0.5,0.1,0.2,3.0,500.0,0.0,11.61,11.835,18.50,1.0,0.01]
x = findgen(100)+1850.0

void = Pan_IkedaCarpenterMon2(parmnames=pnames)
dist = Pan_IkedaCarpenterMon2(x,parms)
if (Keyword_set(plot)) then begin
  title = ['Mon2 Peak',Strjoin(pnames,'; '),Strjoin(String(parms,format='(F6.2)'),'; ')]
  p = Plot(x,dist,title=title,symbol=0,linestyle=0)
endif

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Customized for ARCS instrument at the SNS
;function ICMon2, alpha, beta, R, sigmaM1, tof, Ei=Ei
;compile_opt idl2
;
;; ARCS Instrument parameters
;lFermi = 11.61  ; meters - distance moderator to Fermi chopper 
;lM1 = 11.835    ; meters
;lM2 = 18.50     ; meters
;tBin = 1.0      ; usec - histogram bin size of the monitor data
;mWidth = 0.01   ; meters == 1 cm - monitor effective thickness along the beam
;
;; ensure Ei is defined
;if (n_elements(Ei) eq 0) then Ei = 500 ; default to 500 meV
;
;; expected flight time to M2 due to Ei
;vi = sqrt(Ei/5.22e-6) ; neutron velocity in m/s
;TM2 = 1e6*LM2/Vi      ; travel time to M2 in usec, hence 1e6 factor.
;; Mean emmision time of neutrons at the source
;te = 3/alpha + R/beta
;tM2 = TM2 + Te  ; add mean emmision time to travel time
;
;; Now need to evaluate the time distribution of the neutrons at M2
;; by scaling the IC parameters by the instrument length at M2
;
;; sigma at m2 rel to sigma at M1
;sigmaDet = sqrt(((mWidth/vi)^2 + tBin^2)/12.0)    ; travel time across monitor + histogram bin width
;sigmaM1Cor = sqrt(sigmaM1^2 - sigmaDet^2)         ; rem sigmaDet before scaling
;sigmaM2Cor = sigmaM1Cor* LM2/lM1                  ; Scale sigma from M1 to M2
;sigmaM2 = sqrt(sigmaM2Cor^2 + sigmaDet^2)         ; add sigmaDet
;
;; alpha at M2 rel to source
;sf = (lFermi/(lM2-lFermi))
;alphaM2 = alpha*sf
;betaM2 = beta*sf
;
;dist = ICGauss(alphaM2, betaM2, R, sigmaM2, tM2 - tof)
;
;return, dist
;end