; $Id$
;###############################################################################
;
; NAME:
;  Pan_recoil_2D
;
; PURPOSE:
;  Recoil function (q^2 dependence of the peak, Q dependence of width) for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function Pan_recoil_2D,x,parms,$
  parmnames=parmnames, single_parmnames=single_parmnames, multi_parmnames=multi_parmnames,    $
  canDraw=canDraw, drawMessage=drawMessage, xrange=xrange, xunits=xunits, $
  func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, initParms=initParms, $
  qvals=qvals,xVals=xVals,yVals=yVals,groupNumber=groupNumber,qGroup=qGroup, $
  changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, $
  resPtr=resPtr, resLimit=rLimit,resolutionRequiredFlag=resolutionRequiredFlag, extConvolFlag=extConvolFlag, $
  _Extra = extra

nx = isa(x)? n_elements(x) : n_elements(xvals)
nq = n_elements(qvals)
ux = 1+bytarr(nx)     ; unit vector along x
uq = 1+bytarr(nq)     ; unit vector along q or y

canDraw = 1
twoDimFlag = 1
resolutionRequiredFlag = 0   ; does function require a resolution function to be defined 0=>No, 1=>Yes

extConvolFlag = 1           ; does function require external convolution? 0=>No, 1=>Yes
                            ; if set to No, it implies a convolution is performed within this function when a resolution function is present
                            ; Also set to No, if you DO NOT wish any external convolution to be performed at all

if N_params() eq 0 then begin
  parmnames = []
  aname = 'Area'
  parmnames = [parmnames,aname+strtrim(string(indgen(nq)),2)]
  parmnames = ['ReducedPPos','ReducedFWHM',parmnames]
  single_parmnames = ['ReducedPPos','ReducedFWHM']
  multi_parmnames = ['Area']
  
  ;  if (isa(xVals) && isa(yVals)) then begin
  ;    ; Analyse the data, if present to determine initial guess parameters
  ;    yVal = (yVals.ndim eq 2)? yVals[*,groupNumber-1] : yVals ; take the relevant group data if 2D
  ;    ymin = yVal.sort()
  ;    bg = (N_elements(ymin) gt 5)? mean(ymin[0:4]) : ymin[0]
  ;    xpeaks = Get_peak_pos(xVals,yVal-bg,1,fwhm = fwhm)
  ;    sig = fwhm/2.354
  ;    area = Sqrt(2.0*!pi)*sig*(Max(yVal)-bg)
  ;
  ;    cen = xpeaks[0]/qVals[groupNumber-1]^2    ; scale by the q value of the current data
  ;    width = fwhm/qVals[groupNumber-1]
  ;    initparms = [cen,width]
  ;    for i=0,nq-1 do begin
  ;      initparms = [initparms,area]
  ;    endfor
  ;  endif

  Return,-1
endif
  
  
drawMessage = Strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag to set max height and recoil position']
drawMessage[2:3] = ['Hold left mouse button down','and drag to change recoil width']

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...'
  fwhm = 0.1*(xrange[1]-xrange[0])  ; we have to start from somewhere!
  sig  = fwhm/Sqrt(8.0*Alog(2.0))
  area = yMouseClick*Sqrt(2.0*!dpi*sig^2)
  cen  = xMouseClick
  func_dataHash['ymax'] = yMouseClick
  func_dataHash['xMouse'] = xMouseClick
  
  qVal   = qVals[groupNumber-1]

  parms[0] = cen/qVal^2
  parms[1] = fwhm/qVal
  np = N_elements(parms)
  parms[2:np-1] = area
endif

if (Keyword_set(changesecond)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is move to define the function width
  ; translate the position into suitable parameters.
  ;Print,'###Changesecond called within function...'
  fwhm = 2.0*Abs(xMouseClick-func_dataHash['xMouse'])
  sig = fwhm/Sqrt(8.0*Alog(2.0))
  area = func_dataHash['ymax']*Sqrt(2.0*!dpi*sig^2)

  qVal   = qVals[groupNumber-1]

  parms[1] = fwhm/qVal
  np = N_elements(parms)
  parms[2:np-1] = area
endif

areaIndex = Indgen(nq) + 2

; Vectorize
; extrapolote to 2D by multiplying with appropriate unit vector
area = ux#parms[areaIndex]
cen  = ux#(parms[0]*qvals^2)
sig  = ux#(parms[1]*qvals)/2.35482
xq    = x#uq

yout = (area/Sqrt(2.0*!dpi*sig^2))*Exp(-0.5*((xq-cen)/sig)^2)

Return,yout
end