; $Id$
;###############################################################################
;
; NAME:
;  Pan_PowerBkgd_2D
;
; PURPOSE:
;  Power function in 2D for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function Pan_PowerBkgd_2D,x,parms,$
  parmnames=parmnames, single_parmnames=single_parmnames, multi_parmnames=multi_parmnames,    $
  canDraw=canDraw, drawMessage=drawMessage, xrange=xrange,  $
  func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, initParms=initParms, $
  qvals=qvals,xVals=xVals,yVals=yVals,groupNumber=groupNumber,qGroup=qGroup, $
  changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, $
  resPtr=resPtr, resLimit=rLimit,resolutionRequiredFlag=resolutionRequiredFlag, extConvolFlag=extConvolFlag, $
  _Extra = extra

nx = Isa(x)? N_elements(x) : N_elements(xvals)
nq = N_elements(qvals)
ux = 1+Bytarr(nx)
uq = 1+Bytarr(nq)

canDraw = 0
;canDraw = 0
twoDimFlag = 1
resolutionRequiredFlag = 0   ; does function require a resolution function to be defined 0=>No, 1=>Yes

extConvolFlag = 0           ; does function require external convolution? 0=>No, 1=>Yes
; if set to No, it implies a convolution is performed within this function when a resolution function is present
; Also set to No, if you DO NOT wish any external convolution to be performed at all

if N_params() eq 0 then begin
  parmnames = 'ScaleFactor'+Strtrim(String(Indgen(nq)),2)
  parmnames = [parmnames,'Exponent'+Strtrim(String(Indgen(nq)),2)]

  single_parmnames = ''
  multi_parmnames = ['ScaleFactor','Exponent']
  
  initparms = Fltarr(nq) + '0.0'                ; initialize ScaleFactor to 0.0 for all groups
  initparms = [initparms, Fltarr(nq) + '1.0']   ; initialize exponent to 1.0 for all groups

  Return,-1
endif
;  drawMessage = Strarr(4)
;  drawMessage[0:1] = ['Hold left mouse button down','and drag vertically to set background constant']
;  drawMessage[2:3] = ['Hold left mouse button down','and click anywhere to finish']
;
;  if (Keyword_set(changefirst)) then begin
;    ; user is initializing the function graphically
;    ; this block of code is executed when the mouse is first release at the location for the function centroid
;    ; translate the position into suitable parameters.
;    ;Print,'###Changefirst called within function...'
;    parms[*] = yMouseClick
;  endif
;
;  if (Keyword_set(changesecond)) then begin
;    ; user is initializing the function graphically
;    ; this block of code is executed when the mouse is move to define the function width
;    ; translate the position into suitable parameters.
;    ;Print,'###Changesecond called within function...'
;
;  endif


  ;yout = fltarr(n_elements(x),nq)
  ;for i=0, nq-1 do begin
  ;  yout[*,i]= x*0.0 + parms[i]
  ;endfor

  ; Vectorize
  
  index = indgen(nq)
  sf = parms[index]
  exponent = parms[index+nq]
  sf = ux # sf
  exponent = ux # exponent
  
  xq = x # uq
  index = where(xq le 0.0, xLEzero) ; if x le 0.0, then can have NaNs/Inf if exponent is not an integer
  
  yout = sf*xq^exponent
  if (xLEzero gt 0) then yout[index] = 0.0

  Return,yout
end