; $Id$
;###############################################################################
;
; NAME:
;  PANREADMULTTAS
;
; PURPOSE:
;  This widget dialog allows the user to select and load in I,B, or Q type
;  TAS data directly into PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro prtQuit,event
widget_control,event.top,get_uvalue = pState
; Determine which base we are looking at...
if (!version).release lt 5.6 then begin
	widget_control,(*pState).base,get_value = index
endif else begin
	index = widget_info((*pstate).base,/tab_current)
endelse
index = index[0]
(*pState).curBase = index
widget_control,(*pState).xGroup[index],get_value = xi
xi = fix(xi[0]) - 1
widget_control,(*pState).yGroup[index],get_value = yi
yi = fix(yi[0])
y = reform([(*(*pState).dataPtr[index]).data[yi,*]])

if xi ne (-1) then begin
	x = reform([(*(*pState).dataPtr[index]).data[xi,*]])
	xlabel = (*(*pState).dataPtr[index]).prp[xi]
endif else begin
	x = indgen(n_elements(y))
	xlabel = 'channel'
endelse

ylabel = (*(*pState).dataPtr[index]).prp[yi]
header = (*(*pState).dataPtr[index]).header
filesel = (*pState).filenames[index]
dataOut = {x:x,y:y,xlabel:xlabel,ylabel:ylabel,header:header,filesel:filesel}
*(*pState).outPtr = dataOut
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro panReadPlotAll,event
widget_control,event.top,get_uvalue = pState
filenames = (*pState).filenames
nfiles = n_elements(filenames)
for index = 0,nfiles-1 do begin
    (*pState).curBase = index
	widget_control,(*pState).xGroup[index],get_value = xi
	xi = fix(xi[0]) - 1
	widget_control,(*pState).yGroup[index],get_value = yi
	yi = fix(yi[0])
	y = reform([(*(*pState).dataPtr[index]).data[yi,*]])
	if xi ne (-1) then begin
	  x = reform([(*(*pState).dataPtr[index]).data[xi,*]])
	  xlabel = (*(*pState).dataPtr[index]).prp[xi]
	endif else begin
	  x = indgen(n_elements(y))
	  xlabel = 'channel'
	endelse

	ylabel = (*(*pState).dataPtr[index]).prp[yi]
	header = (*(*pState).dataPtr[index]).header
	dataOut = {x:x,y:y,xlabel:xlabel,ylabel:ylabel,header:header}
	*(*pState).outPtr = dataOut
	wset,(*pState).winPix[(*pState).curBase]
	panReadTasPlot,event
	wset,(*pState).winVis[(*pState).curBase]
	device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix[(*pState).curBase]]
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro panReadTasPlot,event
widget_control,event.top,get_uvalue = pState
if n_elements(*(*pState).outPtr) eq 0 then return
x = (*(*pState).outPtr).x
y = (*(*pState).outPtr).y
xtitle = (*(*pState).outPtr).xlabel
ytitle = (*(*pState).outPtr).ylabel

nx = n_elements(x)
if nx eq 1 then begin
  x = [x]
  y = [y]
endif
plot,x,y,psym = 4,xtitle = xtitle,ytitle = ytitle,title = (*pState).title
if ytitle eq 'I' then begin
  yerr = sqrt(y)
  errplot,x,y-yerr,y+yerr,width = 0.0
endif

return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro panReadMultTas_event,event
widget_control,event.top,get_uvalue = pState

if tag_names(event,/structure_name) eq 'WIDGET_BASE' then begin
  geom = widget_info(event.top,/geometry)
  ctrlgeom = widget_info((*pState).ctrlBase,/geometry)
  xsize = event.x
  ysize = event.y

  ; New data window dimensions
  newxsize = xsize-ctrlgeom.xsize
  newysize = ysize

  widget_control,(*pState).win,draw_xsize = newxsize, $
                 draw_ysize = newysize
  wdelete,(*pState).winPix
  window,/free,/pixmap,xsize = newxsize,ysize = newysize
  (*pState).winPix = !d.window
  wset,(*pState).winPix
  panReadTasPlot,event
  wset,(*pState).winVis
  device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
endif

xind = where((*pState).xgroup eq event.id,countx)
yind = where((*pState).ygroup eq event.id,county)
if (countx ne 0) or (county ne 0) then begin
  if (countx ne 0) then begin
    index = xind[0]
  endif else begin
    index = yind[0]
  endelse
    (*pState).curBase = index
	widget_control,(*pState).xGroup[index],get_value = xi
	xi = fix(xi[0]) - 1
	widget_control,(*pState).yGroup[index],get_value = yi
	yi = fix(yi[0])
	y = reform([(*(*pState).dataPtr[index]).data[yi,*]])
	if xi ne (-1) then begin
	  x = reform([(*(*pState).dataPtr[index]).data[xi,*]])
	  xlabel = (*(*pState).dataPtr[index]).prp[xi]
	endif else begin
	  x = indgen(n_elements(y))
	  xlabel = 'channel'
	endelse
	ylabel = (*(*pState).dataPtr[index]).prp[yi]
	header = (*(*pState).dataPtr[index]).header
	dataOut = {x:x,y:y,xlabel:xlabel,ylabel:ylabel,header:header}
	*(*pState).outPtr = dataOut
	wset,(*pState).winPix[(*pState).curBase]
	panReadTasPlot,event
	wset,(*pState).winVis[(*pState).curBase]
	device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix[(*pState).curBase]]
endif

return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function panReadMultTAS, path,filenames, group_leader = group_leader
tvlct,r,g,b,/get
loadct,0,/silent
; Widget definition module
if n_params() eq 0 then return,(-1L)	; No filename? Get out!

nfiles = n_elements(filenames)
dataPtr = ptrarr(nfiles,/allocate_heap)
if n_elements(group_leader) gt 0 then begin
  tlb = widget_base(/col,/modal,/tlb_size_events, $
        title = 'PAN/TAS Data Reader', $
        group_leader = group_leader)
endif else begin
  tlb = widget_base(/col,/tlb_size_events, $
        title = 'PAN/TAS Data Reader')
endelse
top = widget_base(tlb,/row)
button_labels = filenames
for i = 0,nfiles-1 do begin
	button_labels[i] = strmid(filenames[i],strlen(path))
endfor

if (!version).release ge 5.6 then begin
  ;tab_base = widget_tab(tlb)
  if strupcase((!version).os_family) eq 'WINDOWS' then begin
	  base = widget_tab(tlb,/multiline)
  endif
  if strupcase((!version).os_family) eq 'UNIX' then begin
 	  base = widget_tab(tlb,multiline = 5)
  endif
  nlabels = n_elements(button_labels)
  rowtab = lonarr(nlabels)
  for i = 0,nlabels-1 do begin
    rowtab[i] = widget_base(base,title = button_labels[i],/row)
  endfor
endif else begin
	tab_base = cw_tabbase(tlb,button_labels,bases = rowtab,/row,/frame)
endelse

;base = cw_tabbase(top,button_labels,/droplist,bases = rowtab,/frame,/row)

xsize = 300 & ysize = 300

ctrlBase = lonarr(nfiles)
ctrlSubBase = lonarr(nfiles)
xGroup = lonarr(nfiles)
yGroup = lonarr(nfiles)
win = lonarr(nfiles)

i = 0
*dataPtr[i] = opan_tasrd(filenames[i]);opan_readnist(filenames[i])
ctrlBase[i] = widget_base(rowtab[i],/col)
ctrlSubBase[i] = widget_base(ctrlBase[i],/row)
xGroup[i] = cw_bgroup(ctrlSubBase[i],['Channel',(*dataPtr[i]).prp],/col,/exclusive, $
              set_value = 0,label_top = 'Indep Var')
yGroup[i] = cw_bgroup(ctrlSubBase[i],(*dataPtr[i]).prp,/col,/exclusive, $
              set_value = 1,label_top = 'Dep Var')
win[i] = widget_draw(ctrlSubBase[i],xsize = xsize,ysize = ysize)
for i = 1,nfiles-1 do begin
  *dataPtr[i] = opan_readnist(filenames[i])
  ctrlBase[i] = widget_base(rowtab[i],/col)
  ctrlSubBase[i] = widget_base(ctrlBase[i],/row)
  xGroup[i] = cw_bgroup(ctrlSubBase[i],['Channel',(*dataPtr[i]).prp],/col,/exclusive, $
              set_value = 0,label_top = 'Indep Var')
  yGroup[i] = cw_bgroup(ctrlSubBase[i],(*dataPtr[i]).prp,/col,/exclusive, $
              set_value = 1,label_top = 'Dep Var')
  win[i] = widget_draw(ctrlSubBase[i],xsize = xsize,ysize = ysize)
endfor

void = widget_button(tlb,value = 'Accept',event_pro = 'prtQuit',xsize = 25)

widget_control,tlb,/realize

; Set all of the ygroups to 'I'
for i = 0,nfiles-1 do begin
  whereI = where((*dataPtr[i]).prp eq 'I',count)
  widget_control,ygroup[i],set_value = whereI[0]
endfor

; Now cycle through all of the fields and determine which parameter is
; varying.
for i = 0,nfiles-1 do begin
  whereI = where((*dataPtr[i]).prp eq 'I',count)
  index = -1
  for j = whereI[0]-1,0,-1 do begin
    d = (*dataPtr[i]).data[j,*]
    if n_elements((*dataPtr[i]).data[j,*]) eq 1 then begin
      index = 0
    endif else begin
      if (*dataPtr[i]).data[j,1] ne (*dataPtr[i]).data[j,0] then begin
        index = j
      endif
    endelse
  endfor
  widget_control,xgroup[i],set_value = index+1
endfor

winVis = lonarr(nfiles)
winPix = lonarr(nfiles)
for i = 0,nfiles-1 do begin
  widget_control,win[i],get_value = vis
  winVis[i] = vis
  window,/free,/pixmap,xsize = xsize,ysize = ysize
  winPix[i] = !d.window
endfor

state =	{dataPtr:dataPtr, $
         filenames:filenames, $
         base:base, $
         rowtab:rowtab, $
		 outPtr:ptr_new(/allocate_heap), $
		 xGroup:xGroup, $
		 yGroup:yGroup, $
		 title:'', $
		 winPix:winPix, $
		 winVis:winVis, $
		 ctrlBase:ctrlBase, $
		 curBase:0, $
		 r:r,g:g,b:b, $
		 win:win}

pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState
pseudoEvent = {event,id:void,top:tlb,handler:0l}

panReadPlotAll,pseudoEvent
xmanager,'panreadmulttas',tlb
; Restore colors present upon entry before leaving
tvlct,(*pState).r,(*pState).g,(*pState).b
if n_elements(*(*pState).outPtr) gt 0 then begin
  output = *(*pState).outPtr
endif else begin
  output = (-1L)
endelse

for i = 0,nfiles-1 do begin
  wdelete,(*pState).winPix[i]
endfor
ptr_free,(*pState).dataPtr
ptr_free,(*pState).outPtr
ptr_free,pState

return,output
end