; $Id$
;###############################################################################
;
; NAME:
;  OPAN__REMOVEXRANGE_WIDGET
;
; PURPOSE:
;  This widget dialog allows the user to specify an xrange over which
;  data should be eliminated from the fit.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Richard Tumanjong Azuah
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-5604
;   E-mail: azuah@nist.gov
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro opan_removexrange,event
widget_control,event.top,get_uvalue = pState
case event.id of
(*pState).cancelButton:	$
			begin
			  (*pState).out.cancel = 1
			  widget_control,event.top,/destroy
			end
(*pState).acceptButton: $
			begin
;			widget_control,(*pState).ndesired,get_value = nbins
;			(*pState).out.nbins = fix(nbins[0])
			widget_control,(*pState).xdlo,get_value = xlo
			(*pState).out.xlo = xlo[0]
			widget_control,(*pState).xdhi,get_value = xhi
			(*pState).out.xhi = xhi[0]
			(*pState).out.cancel = 0
			widget_control,event.top,/destroy
 			end
else:
endcase
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function opan_removexrange_widget,x,group_leader = group_leader
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = 'Exclude Data',/tlb_frame_attr)
endif else begin
  tlb = widget_base(group_leader = group_leader, /col,/modal, $
        title = 'Exclude Data',/tlb_frame_attr)
endelse
base = widget_base(tlb,/col)
;xlo = min(x) & xhi = max(x) & nx = n_elements(x)

base2 = widget_base(base,/col,/frame)
void = widget_label(base2,value = 'Specify x-axis limits to be excluded',/align_center)
void = widget_label(base2,value = '(WARNING: Does not work when a resolution function is loaded)',/align_center)
xdlo = cw_field(base2,/row,value = 0.0,/float,title = 'Lower limit')
xdhi = cw_field(base2,/row,value = 0.0,/float,title = 'Upper limit')

acceptButton = widget_button(tlb,value = 'Accept')
cancelButton = widget_button(tlb,value = 'Cancel')

widget_control,tlb,/realize

out = {xlo:0.0,xhi:0.0,cancel:1}
state = {out:out, $
         xdlo:xdlo, xdhi:xdhi, $
         cancelButton:cancelButton, $
         acceptButton:acceptButton}

pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState
xmanager,'opan_removexrange_widget',tlb,event_handler = 'opan_removexrange'

out = (*pState).out
ptr_free,pState
return,out
end
