; $Id$
;###############################################################################
;
; NAME:
;  OPAN_READNISTB
;
; PURPOSE:
;  Reads in NIST "B" type TAS files.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function opan_readnistb,filen

;read the nist data of type "B"

; OUPUTS:
;               a data structure consisting of:
;                 d.points - integer - # of points in scan
;                 d.heads - integer - # of header parameters
;                 d.pars - integer - # of scan parameters
;                 d.text - string array - 2 lines of descriptive text
;                 d.hdef - string array - definition of header parameters
;                 d.hnum - float array - header parameters
;                 d.prp - string array - definition of scan parameters
;                 d.data - 2D float array - scan data (parameter,point#)

qpoints=0
qheads=24
qtext=['','']
qhdef=STRARR(30)
qhnum=FLTARR(30)
qprp=STRARR(30)
qdata=FLTARR(30,5000)
qpars=0

;for 'B' type data, the number of parameters are not fixed(d.pars)


temp=''
ttemp=''
teemp=''
temmp=''
tempp=''


junk=''

openr,unit,filen,/get_lun

readf,unit,junk
header = junk
qtext(0)=strlowcase(strmid(junk,1,8))   ;filename

temp=readword(junk,5)
if (temp ne 'NEUT') then qheads=25
;if neut put Mon in the data part
;else put it in the heads

temp=readword(junk,3)
ttemp=readword(junk,4)
;read the Mon and the Prf

Mon=0.0
Prf=0.0
reads,temp,Mon,format='(f)'
reads,ttemp,Prf,format='(f)'

Mon=Mon*Prf

;get the number of data points
temp=readword(junk,6)
reads,temp,qpoints,format='(i)'

readf,unit,junk  ;the second line
header = [header,junk]
readf,unit,junk  ;the third line
header = [header,junk]
;qtext(0)=strmid(junk,0,6)
qtext(1)=strmid(junk,6,strlen(junk)-6)

qhdef(0:23)=['RMC','MSC','SAC','ADC','ETAM','ETAS','ETAA','HA','KA','LA','FI',$
	'HB','KB','LB','a','b','c','alph','beta','gamm','EF','TAUM',$
	'TAUA','HFLD']

qprp(0:5)=['A1','A2','A3','A4','A5','A6']

if qheads eq 25 then begin
	qhdef(24)='Mon'
	qhnum(24)=Mon
endif



j=0.0

readf,unit,junk   ;the fourth line
header = [header,junk]
for i=0,13 do begin
	temp=readword(junk,i)
	reads,temp,j,format='(f)'
	qhnum(i)=j
endfor

readf,unit,junk   ;the 5th line
header = [header,junk]
readf,unit,junk   ;the 6th line
header = [header,junk]
for i=14,19 do begin
	temp=readword(junk,i-14)
	reads,temp,j,format='(f)'
	qhnum(i)=j
endfor

k=0.0
readf,unit,junk   ;the 7th line
header = [header,junk]
readf,unit,junk   ;the 8th line
header = [header,junk]
for i=0,2 do begin
	temp=readword(junk,i+2)
	reads,temp,j,format='(f)'
	qhnum(i+20)=j
endfor

qhnum(21)=2*3.1415826/qhnum(21)
qhnum(22)=2*3.1415826/qhnum(22)

readf,unit,junk   ;the 9th line
header = [header,junk]
readf,unit,junk   ;the 10th line
header = [header,junk]
temp=readword(junk,6)
reads,temp,i,format='(f)'
qhnum(23)=i

readf,unit,junk   ;skip 1 line
header = [header,junk]
mstart=0.0
mstep=0.0
for i=0,5 do begin
	readf,unit,junk
	temp=readword(junk,1)
	reads,temp,mstart,format='(f)'
	temp=readword(junk,2)
	reads,temp,mstep,format='(f)'
	qdata(i,0)=mstart
	for j=1,qpoints-1 do qdata(i,j)=qdata(i,j-1)+mstep
endfor

readf,unit,junk
header = [header,junk]
readf,unit,junk
header = [header,junk]

ww=0

while (strmid(readword(junk,ww),0,1) eq 'A') and $
	(strlen(readword(junk,ww)) eq 2)  do ww=ww+1

i=ww
qpars=6
time=0     ;the position for TIM
while (readword(junk,i) ne '') do begin
	temp=readword(junk,i)
	if temp eq 'MIN' then  begin
		temp='TIM'
		time=i
	endif
	if temp eq 'COUNTS' then temp='I'
	qprp(qpars)=temp
	qpars=qpars+1
	i=i+1
endwhile


on_ioerror,kill

for i=0,qpoints-1 do begin
	readf,unit,junk   ;the ith data line
	for j=0,qpars-7 do begin
		temp=readword(junk,ww+j)
		reads,temp,k,format='(f)'
		qdata(j+6,i)=k
	endfor
qdata(6+time-ww,i)=qdata(6+time-ww,i)*60  ;convert minutes to seconds
endfor

goto,notkill

kill:
        qpoints=i
        on_ioerror,null
notkill:

if qheads eq 24 then begin
	qpars=qpars+1
	qprp(qpars-1)='MON'
	qdata(qpars-1,*)=MON
endif

if qprp(qpars-1) eq 'MON' then begin
	for i=0,qpoints-1 do begin
		qdata(qpars,i)=sqrt(qdata(qpars-2,i))
		qdata(qpars+1,i)=sqrt(qdata(qpars-1,i))
	endfor
	qprp(qpars)='SIGI'
	qprp(qpars+1)='SIGM'
	qpars=qpars+2
endif else begin
	for i=0,qpoints-1 do qdata(qpars,i)=sqrt(qdata(qpars-1,i))
	qprp(qpars)='SIGI'
	qpars=qpars+1
endelse


free_lun, unit,/force		;close the file

scan={points:qpoints,heads:qheads,pars:qpars,text:qtext,$
      hdef:qhdef(0:qheads-1), $
      hnum:qhnum(0:qheads-1),prp:qprp(0:qpars-1),$
      data:qdata(0:qpars-1,0:qpoints-1), $
      header:header}

return,scan
end


