; $Id$
;###############################################################################
;
; NAME:
;  OPAN_READNIST
;
; PURPOSE:
;  Driver function to read in NIST TAS data.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function opan_readnist,filen

;this is not just a test

; OUPUTS:
;               a data structure consisting of:
;                 d.points - integer - # of points in scan
;                 d.heads - integer - # of header parameters
;                 d.pars - integer - # of scan parameters
;                 d.text - string array - 2 lines of descriptive text
;                 d.hdef - string array - definition of header parameters
;                 d.hnum - float array - header parameters
;                 d.prp - string array - definition of scan parameters
;                 d.data - 2D float array - scan data (parameter,point#)
;				  d.header - entire file header

;d={points:0,heads:0,pars:0,text:STRARR(2),hdef:STRARR(30),  $
;   hnum:FLTARR(30),prp:STRARR(30),data:FLTARR(30,5000)}

junk=''

openr,unit,filen,/get_lun

;read in the data from the first line and the second line

readf,unit,junk
free_lun, unit,/force		;close the file
junk		=	strtrim(junk,2)
jj		=	strmid(junk,36,1)

if (jj eq 'Q') or (jj eq 'T') then 				$
d=opan_readnistq(filen)						$
else if jj eq 'I' then						$
d=opan_readnisti(filen)						$
else if jj eq 'B' then						$
d=opan_readnistb(filen)

return,d


end