; +
; NAME:
;
;  HC_DRIVER
;
; PURPOSE:
;
;  This application reads in an instrumental resolution function
;  and the sample data and fits the honeycomb jump model to the
;  data.  This program uses the HC_DATA object class.
;
; AUTHOR:
;
;  Robert Dimeo
;  National Institute of Standards and Technology
;  Center for Neutron Research
;  100 Bureau Drive, Mail Stop 8562
;  Gaithersburg, MD 20899
;  Tel: (301) 975-8135
;  Email: robert.dimeo@nist.gov
;
; CATEGORY:
;
;  Data analysis
;
; REQUIREMENTS
;
;  IDL 6.0 or higher
;
; ADDITIONAL REQUIRED PROGRAMS
;
;  HC_DATA__DEFINE.PRO
;  MPFIT.PRO
;  MPCURVEFIT.PRO
;
; MODIFICATION HISTORY:
;
;  Writing began -- 6/14/04 (RMD)
; -
; *************************************************** ;
pro hc_driver,dir,res_filename,data_filename,res_params_filename
if n_params() eq 0 then begin
   dir = 'c:\bhd\dave_development\dave\programs\testing\cappelletti\'
   res_filename = '300K_resolution_sam1SSQW_rb.dave'
   data_filename = '580K_sam1SSQW_rb.dave'
   res_params_filename = 'res_fit_params.fit';'new_res_fit_parms.fit';'resolution_fit_params.fit'
   if ~file_test(dir+res_filename) then return
   if ~file_test(dir+data_filename) then return
   if ~file_test(dir+res_params_filename) then return
   msg = 'data files present'
endif else begin
   if n_params() ne 0 then return
   if ~file_test(dir+res_filename) then return
   if ~file_test(dir+data_filename) then return
   if ~file_test(dir+res_params_filename) then return
   msg = 'data files present'
endelse

; Ok, the data files are present...let's open them up:
odata = obj_new('hc_data',dir+data_filename)
ret = odata->get_property(ny = ny)
ret = odata->load_resolution_params(dir+res_params_filename,msg = msg)
ret = odata->get_property(res_str = res_str)
ret = odata->set_property(ntheta = 10,nphi = 10)
ret = odata->fit(msg = msg,niter = 3)

ret = odata->get_property(yfit = yfit,xvals = xvals,yvals = yvals,qty = qty)
;plot,xvals,yfit[*,1],psym = 0
;for i = 1,n_elements(yvals)-1 do begin
;   oplot,xvals,yfit[*,i],psym = 0
;endfor

plot,xvals,qty[*,2],psym = 4
oplot,xvals,yfit[*,2],psym = 0,thick = 2.0

obj_destroy,odata
help,/heap,/brief
end
; *************************************************** ;
