; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;************************************************************************************************
;
; These procedures are used by the program "slab_ss"
;
;************************************************************************************************

pro slab_ss_checkinput,event,checkstring,vals,ok,messages
;************************************************************************************************
;
compile_opt strictarr
widget_control,event.top,get_uvalue = pState
;
;
ok=1
;
messages=''
case checkstring of
	"phivals": begin
		if(event.id eq (*pState).butt_phi) then begin
			if(n_elements(vals) ne 3) then begin
				ok=0
				messages=[messages,'You must provide three numbers (start, stop and step)!']
				phistart = (*pState).phistart_def
				phistop  = (*pState).phistop_def
				phistep  = (*pState).phistep_def
		  	phivals=[phistart,phistop,phistep]
				phivals=strjoin(string(phivals,format='(f7.2)'),',')
				widget_control,(*pState).butt_phi,set_value = phivals
				slab_ss_event,event
			endif
		endif
	end
;
	"angles": begin
		if(event.id eq (*pState).butt_phi) then begin
			philo=vals[0]
			phihi=vals[1]
			dphi=vals[2]
			if (philo ge phihi) then begin
				ok=0
				messages=[messages,'Start angle 2theta must be less than stop angle 2theta!']
 				phistart = (*pState).phistart_def
				phistop  = (*pState).phistop_def
				phistep  = (*pState).phistep_def
		   	phivals=[phistart,phistop,phistep]
				phivals=strjoin(string(phivals,format='(f7.2)'),',')
				widget_control,(*pState).butt_phi,set_value = phivals
				slab_ss_event,event
			endif
			if (dphi le 0.d0) then begin
				ok=0
				messages=[messages,'Step in 2theta must be positive!']
				phistart = (*pState).phistart_def
				phistop  = (*pState).phistop_def
				phistep  = (*pState).phistep_def
	   		phivals=[phistart,phistop,phistep]
				phivals=strjoin(string(phivals,format='(f7.2)'),',')
				widget_control,(*pState).butt_phi,set_value = phivals
				slab_ss_event,event
			endif
		endif
	end
;
	"sigmatS": begin
		if(event.id eq (*pState).butt_sigmatS) then begin
	 		if(vals lt 0.d) then begin
	 			ok=0
		    messages=[messages,'Total cross section for sample cannot be negative!']
		   	sigmatS=(*pState).sigmatS_def
		   	widget_control,(*pState).butt_sigmatS,set_value = sigmatS
		   	slab_ss_event,event
	  	endif
  	endif
  end

;
	"sigmatC": begin
		if(event.id eq (*pState).butt_sigmatC) then begin
		 	if(vals lt 0.d) then begin
	 			ok=0
		    messages=[messages,'Total cross section for container cannot be negative!']
		   	sigmatC=(*pState).sigmatC_def
   			widget_control,(*pState).butt_sigmatC,set_value = sigmatC
		   	slab_ss_event,event
	  	endif
  	endif
  end
;
	"thicknessS": begin
		if(event.id eq (*pState).butt_thicknessS) then begin
		 	if (vals lt 0.d) then begin
		 		ok=0
	  		messages=[messages,'Sample thickness cannot be negative!']
	  		thicknessS=(*pState).thicknessS_def
	  		widget_control,(*pState).butt_thicknessS,set_value = thicknessS
	  		slab_ss_event,event
	  	endif
	  endif
	end
;
	"thicknessC": begin
		if(event.id eq (*pState).butt_thicknessC) then begin
		 	if (vals lt 0.d) then begin
		 		ok=0
	  		messages=[messages,'Container thickness cannot be negative!']
	  		thicknessC=(*pState).thicknessC_def
	  		widget_control,(*pState).butt_thicknessC,set_value = thicknessC
	  		slab_ss_event,event
	  	endif
	  endif
	end
;
	"psi0": begin
		if (event.id eq (*pState).butt_psi0) then begin
			if (vals lt -90.0) or (vals gt 90.0) then begin
				ok=0
				messages=[messages,'The inclination angle psi0 must be between -90.0 and 90.0.',$
				'For details look at the Help file.']
				psi0=(*pState).psi0_def
				widget_control,(*pState).butt_psi0,set_value = psi0
				slab_ss_event,event
			endif
		endif
	end
;
	else:
endcase
;
end


;************************************************************************************************
pro slab_ss_WinDraw,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
if (not (*pState).plotting_geometry and n_elements(*(*pState).ssfPtr) eq 0) then return
;
default_colors=(*pState).default_colors
;colorset
tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
;
!x=(*pState).bangx
!y=(*pState).bangy
!p=(*pState).bangp
;
case event.type of
	0: begin  ; button press
		(*pState).mouse = event.press
		if (*pState).mouse eq 4 then begin
		  (*pState).autoscale = 1
				;colorset
	  	tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
	  	wset,(*pState).winPix
			slab_ss_2plotter,event,/redraw
			wset,(*pState).winVis
			device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
			tvlct,default_colors
			(*pState).mouse = 0
			widget_control,event.top,set_uvalue = pState
			tvlct,default_colors
			return
		endif
		(*pState).xp1 = event.x
		(*pState).yp1 = event.y
		(*pState).autoscale = 0
	end
;
	1: begin	; button release
		if ((*pState).mouse eq 1) then begin
			x = (*pState).xp1 < (*pState).xp2
			y = (*pState).yp1 < (*pState).yp2
			w = abs((*pState).xp1 - (*pState).xp2)
			h = abs((*pState).yp1 - (*pState).yp2)
			x2 = x+w
			y2 = y+h
			lc = convert_coord(x, y, /device, /to_data)
			uc = convert_coord(x2, y2, /device, /to_data)
			(*pState).xlo = lc[0] & (*pState).xhi = uc[0]
			(*pState).ylo = lc[1] & (*pState).yhi = uc[1]
			;colorset
		  tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
		  wset,(*pState).winPix
			slab_ss_2plotter,event,/redraw
			wset,(*pState).winVis
			device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
			tvlct,default_colors
		endif
		(*pState).mouse = 0
  end
;
	2: begin	; mouse motion
    if ((*pState).mouse eq 1) then begin
    	(*pState).xp2 = event.x
    	(*pState).yp2 = event.y
    	xc = [(*pState).xp1, event.x, event.x, (*pState).xp1, (*pState).xp1]
    	yc = [(*pState).yp1, (*pState).yp1, event.y, event.y, (*pState).yp1]
			wset, (*pState).winVis
	    device, copy = [0,0,(*pState).winxsize,(*pState).winysize,0,0, (*pState).winPix]
	    ;colorset
  		tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
    	plots, xc, yc, /device, color=1
    	tvlct,default_colors
    endif
   end
;
	else:
;
endcase
widget_control,event.top,set_uvalue = pState
tvlct,default_colors
return
end


;************************************************************************************************
pro slab_ss_WriteFactors,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
;
if (n_elements(*(*pState).ssfPtr) eq 0) then begin
	res=dialog_message("Nothing found to save to a file.",/information)
	return
endif
;
defsysv,'!dave_defaults',exists=exists
if (exists) then begin
	path=(*!dave_defaults).workDir
	filename=dialog_pickfile(dialog_parent=event.top,path=path,filter='*.txt',/write,title='Output file')
endif else begin
	filename=dialog_pickfile(dialog_parent=event.top,filter='*.txt',/write,title='Output file')
endelse
if (strlowcase(strmid(filename,strlen(filename)-4)) ne '.txt') then filename=filename+'.txt'
openw,lun,filename,/get_lun
;
phi=*(*pState).phiPtr
phistart=phi[0]
nphi=n_elements(phi)
phistop=phi[nphi-1]
phistep=(phistop-phistart)/(nphi-1)
phivals=[phistart,phistop,phistep]
phivals=strjoin(string(phivals,format='(f7.2)'),',')
;
printf,lun,"Slab geometry"
printf,lun," 15"
;
printf,lun,"Sample thickness t_S (cm)"
printf,lun,(*pState).thicknessS
printf,lun,"Total cross section (sample), sigt_S (cm-1)"
printf,lun,(*pState).sigmatS
printf,lun,"Container wall thickness t_C (cm)"
printf,lun,(*pState).thicknessC
printf,lun,"Total cross section (container), sigt_C (cm-1)"
printf,lun,(*pState).sigmatC
printf,lun,"Inclination angle psi0 (deg)"
printf,lun,(*pState).psi0
printf,lun,"Angle sign conventions"
printf,lun,(*pState).signconv
printf,lun,"Transmissions TS0, TC0, T=TC0*TS0*TC0
printf,lun,(*pState).ts0,(*pState).tc0,(*pState).tc0*(*pState).ts0*(*pState).tc0
printf,lun,"Angle, SSF, fcsc, fcc, SAF, tS, tC"
;
thisFormat='(f8.2,6f10.5)'
for i=0,nphi-1 do begin
	dataOut=$
		[(*(*pState).phiPtr)[i],$
		(*(*pState).ssfPtr)[i],$
		(*(*pState).fcscPtr)[i],$
		(*(*pState).fccPtr)[i],$
		(*(*pState).safPtr)[i],$
		(*(*pState).tsPtr)[i],$
		(*(*pState).tcPtr)[i]]
 	printf,lun,dataOut,format=thisFormat
endfor
;
free_lun,lun
;
return
end


;************************************************************************************************
pro slab_ss_procs
;************************************************************************************************
;
compile_opt strictarr
;
end