; $Id$
Function BaseLayout, BaseID
;
; Guess what kind of base this is based
; upon the layout of its children.
;
BaseType = 'Unknown'
Child = Widget_Info(BaseID, /Child)
If (Widget_Info(Child, /Valid_ID)) then Begin
   Sibling = Widget_Info(Child, /Sibling)
   If (Widget_Info(Sibling, /Valid_ID)) then Begin
     GeomChild1 = Widget_Info(Child, /Geometry)
     GeomChild2 = Widget_Info(Sibling, /Geometry)
     Case 1 of
      GeomChild1.XOffset eq GeomChild2.XOffset : BaseType = 'Column'
      GeomChild1.YOffset eq GeomChild2.YOffset : BaseType = 'Row'
      Else :
     EndCase
   EndIf
EndIf
Return, BaseType
End

Pro Widget_TreeView, Wid, Indent,wid_out
Compile_Opt StrictArr
if n_params() lt 3 then wid_out = wid
If (Widget_Info(Wid, /Valid_ID)) then Begin

         Mapped = Widget_Info(Wid, /Map)
         Visible = Widget_Info(Wid, /Visible)
         MapVis = ' [Map=' + StrTrim(Mapped, 2) + ',Vis=' + StrTrim(Visible, 2) + '] '
   If (N_elements(Indent) eq 0) then Begin
      Spaces = ''
      Indent = 0
   EndIf Else Begin
      If (Indent gt 0) then Begin
          Spaces = StrJoin(Replicate(' ', Indent))
      EndIf Else Begin
          Spaces = ''
      EndElse
   EndElse
   BaseLayout = ''
   UName = Widget_Info(Wid, /UName)
   Type = Widget_Info(Wid, /Name)
   ThisType = Where(['BUTTON', 'DRAW', 'LABEL', 'SLIDER', 'TEXT', 'TAB', 'TREE', 'COMBOBOX'] eq Type, NThisType)
   If (NThisType ne 0) then Begin
      ToContinue = 1
      Catch, ErrorNumber
      If (ErrorNumber ne 0) then Begin
         Catch, /Cancel
         ToContinue = 0
      EndIf
      If (ToContinue) then Begin
         Widget_Control, Wid, Get_Value = Value
         Catch, /Cancel
         If (N_elements(Value) eq 0) then Begin
            Value = ''
         EndIf Else Begin
            ToContinue = 1
            Catch, ErrorNumber
            If (ErrorNumber ne 0) then Begin
              Catch, /Cancel
              ToContinue = 0
            EndIf
            If (ToContinue) then Begin
               Value = ' Value = ' + StrTrim(Value[0], 2)
                 Catch, /Cancel
           EndIf Else Begin
              Help, Value, Output = Value
           EndElse
            If (StrLen(Value[0]) gt 20) then Begin
               Value = StrMid(Value, 0, 17) + '...'
            EndIf
         EndElse
      EndIf Else Begin
         If (Type ne 'TAB') then Begin
            Value = '[BITMAP]'
         EndIf Else Begin
            Value = '[TAB Container]'
         EndElse
      EndElse
   EndIf Else Begin
      Value = ''
      If (Type eq 'BASE') then Begin
        BaseLayout = 'Type = ' + BaseLayout(Wid)
      EndIf
   EndElse

;   print, Spaces, Type, '(' + StrTrim(Wid, 2) + ',' + $
;      UName + ')' + MapVis + Value + ' ' + BaseLayout

   if n_elements(wid_out) eq 0 then begin
      wid_out = wid
;      print,'Here:',wid_out
   endif else begin
      wid_out = [wid_out,wid]
;      print,'There: ',wid_out
   endelse

   NewWid = Widget_Info(Wid, /Child)
   If (NewWid ne 0) then Begin
      Widget_TreeView, NewWid, Indent + 3,wid_out
   EndIf
   NewWid = Widget_Info(Wid, /Sibling)
   If (NewWid ne 0) then Begin
      Widget_TreeView, NewWid, Indent,wid_out
   EndIf Else Begin
      Indent = Indent - 3
   EndElse
EndIf
End
