; $Id$
;###############################################################################
;
;FILENAME:
;launch_convertbt1todave.pro
;
;PURPOSE:
;           Launch BT1 Data Converter.
;CATEGORY:
;
;
;METHODS IN FILE:
;
;    launch_convertbt1todave
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Oct 31,2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
;
pro launch_convertbt1todave,event,dataDir=dataDir,workDir=workDir,$
                                  daveTool=daveTool,group_leader=group_leader,$
                                  _extra=extra
;
;NAME:
;        launch_convertbt1todave
;
;PURPOSE:
;           Launch .bt1 to .dave conversion application from DAVE.
;PARAMETERS:
;           event   Event to launch the module.
;KEYWORDS:
;           None.

    if n_elements(group_leader) ne 0 then begin
          
      wid = cwo_ConvertBT1ToDave(dataDir=dataDir,workDir=workDir,$
                                  daveTool=daveTool,group_leader=group_leader)
    
    endif else begin
    
      if n_elements(event) ne 0 then begin
      
        this_event = tag_names(event,/structure_name)
        case this_event of
        'WIDGET_BUTTON': $
            begin
                wid = cwo_ConvertBT1ToDave(group_leader=event.top,$
                                           dataDir=dataDir,workDir=workDir,$
                                           daveTool=daveTool)
            end
        'WIDGET_TREE_SEL': $
            begin
                wid = cwo_ConvertBT1ToDave(group_leader=event.top,$
                                           dataDir=dataDir,workDir=workDir,$
                                           daveTool=daveTool)
            end
        else:
        endcase
      endif else begin
        wid = cwo_ConvertBT1ToDave(dataDir=dataDir,workDir=workDir,$
                                   daveTool=daveTool,$
                                   _extra=extra)
      endelse
    endelse

end;launch_mergeIQT
