; $Id$
;###############################################################################
;
; NAME:
;  TAS_SEL_N_CURVES
;
; PURPOSE:
;
; CATEGORY:
;  DAVE, TAS, Data Reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; +
;
; -
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tsn_send_info,event
widget_control,event.top,get_uvalue = pstate
slider_id = widget_info(event.top,find_by_uname = 'CURVE_SLIDER')
widget_control,slider_id,get_value = val & ncurves = val[0]
notify_ids = (*pstate).notify_ids
if (*pstate).notify_ids[0] eq 0L then return
info =   {tsn_event,             $
          id:notify_ids[0],      $
          top:notify_ids[1],     $
          handler:0L,            $
          wid:event.top,         $
          ncurves:ncurves        }
if widget_info(notify_ids[0],/valid_id) then begin
  widget_control,notify_ids[0],send_event = info
endif
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tsn_cleanup,tlb
widget_control,tlb,get_uvalue = pstate
ptr_free,pstate
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tsn_event,event
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
'DISMISS': begin
   tsn_send_info,event          ; RTA - only send slider event when done!
   widget_control,event.top,/destroy
end
'CURVE_SLIDER':  begin
;   tsn_send_info,event
end
else: begin
   tsn_send_info,event
   widget_control,event.top,/destroy
end
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_sel_n_curves,      group_leader = group_leader,  $
                           notify_ids = notify_ids,      $
                           ncurves = ncurves,            $
                           curve_name = curve_name

if n_elements(register_name) eq 0 then $
   register_name = 'tas_sel_ncurves'
if xregistered(register_name) then return
event_handler = 'tsn_event' & cleanup = 'tsn_cleanup'
; Check for which parameters were passed in
if n_elements(group_leader) eq 0 then group_leader = 0L
if n_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
if n_elements(ncurves) eq 0 then ncruves = 1
if n_elements(curve_name) eq 0 then curve_name = 'Gaussians'
; Widget definition module
title = 'Number of '+curve_name
modal = 1
tlb = widget_base(group_leader = group_leader,/col, title = title,   $
   tlb_frame_attr = 9,xsize = 200,modal=modal,/base_align_center)
slider_title = '# of '+curve_name

slider = rmd_arrows(tlb,value = 1,minimum = 1,maximum = 10,   $
   uname = 'CURVE_SLIDER', title = slider_title,xsize = 3, $
   /align_center)


;slider = cw_field_arrows(tlb,value = 1,min = 1,max = 10,   $
;   uname = 'CURVE_SLIDER', title = slider_title,xsize = 3)

;slider = widget_slider(tlb,value = 1,min = 1,max = 10,   $
;   uname = 'CURVE_SLIDER', title = slider_title,xsize = 250)
rowbase = widget_base(tlb,/row)
void = widget_button(rowbase,value = 'OK',uname = 'DISMISS',/align_center)

centertlb,tlb

widget_control,tlb,/realize
state =  {  notify_ids:notify_ids}
pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate

; Send a pseudo-event up so that just launching this slider
; causes a fit attempt with one curve.
;pevent = {event,id:slider,top:tlb,handler:0L}
;tsn_send_info,pevent
;rta - only send slider event when this dialog is dismissed

xmanager,register_name,tlb,event_handler = event_handler, cleanup=cleanup,no_block=modal

end
