; $Id$
;###############################################################################
;
; NAME:
;  DTAS_LEGEND_PREFS
;
; PURPOSE:
;
; CATEGORY:
;  DAVE, TAS, Data Reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_convert_slider,xpos,ypos,nzx,nzy
; Convert the xpos and ypos to slider values
dx_dzx = 1.0/float(nzx)
dy_dzy = 1.0/float(nzy)

xo = fix(xpos/dx_dzx)
yo = fix(ypos/dy_dzy)
return,[xo,yo]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_convert_value,xo,yo,nzx,nzy
; Convert the xpos and ypos to slider values
dx_dzx = 1.0/float(nzx)
dy_dzy = 1.0/float(nzy)
xpos = xo*dx_dzx
ypos = yo*dy_dzy
return,[xpos,ypos]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro leg_cleanup,tlb
widget_control,tlb,get_uvalue = pstate
heap_free,pstate
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dtas_legend_get_values,event
widget_control,event.top,get_uvalue = pstate
vslider_id = widget_info(event.top,find_by_uname = 'VSLIDER')
hslider_id = widget_info(event.top,find_by_uname = 'HSLIDER')
charsize_id = widget_info(event.top,find_by_uname = 'CHARSIZE')
widget_control,vslider_id,get_value = v_index & v_index = v_index[0]
widget_control,hslider_id,get_value = h_index & h_index = h_index[0]
result = dtas_convert_value(h_index,v_index,(*pstate).nzx,(*pstate).nzy)
widget_control,charsize_id,get_value = this_value
charsize = float(this_value[0])
(*(*pstate).prefs_ptr).xpos = result[0]
(*(*pstate).prefs_ptr).ypos = result[1]
(*(*pstate).prefs_ptr).charsize = charsize
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dtas_legend_send_info,event
widget_control,event.top,get_uvalue = pstate
notify_ids = (*pstate).notify_ids
prefs = (*pstate).prefs_ptr
if (*pstate).notify_ids[0] eq 0L then return
info =   {prefs_legend_event,    $
          id:notify_ids[0],      $
          top:notify_ids[1],     $
          handler:0L,            $
          prefs:prefs}
if widget_info(notify_ids[0],/valid_id) then begin
  widget_control,notify_ids[0],send_event = info
endif

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dtas_legend_prefs_event,event
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
'DISMISS':  widget_control,event.top,/destroy
else: $
   begin
      dtas_legend_get_values,event
      dtas_legend_send_info,event
   end
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dtas_legend_prefs,prefs, group_leader = group_leader,notify_ids = notify_ids, $
   register_name = register_name
; Widget definition module
if n_params() eq 0 then return
if n_elements(group_leader) eq 0 then return
if n_elements(notify_ids) eq 0 then return
if n_elements(register_name) eq 0 then register_name = 'dtas_legend'
if xregistered(register_name) then return
xpos = prefs.xpos & ypos = prefs.ypos & charsize = prefs.charsize
nzx = 20 & nzy = 20
result = dtas_convert_slider(xpos,ypos,nzx,nzy)
xo = result[0] & yo = result[1]

tlb = widget_base(title = 'Plot Legend Preferences', group_leader = group_leader, $
   tlb_frame_attr = 9,/col)

void = widget_slider(tlb,value = xo,min = 1,max = nzx,title = 'Vertical position', $
   /vertical, ysize=150, uname = 'VSLIDER')
void = widget_slider(tlb,value = yo,min = 1,max = nzy,title = 'Horizontal position', $
   uname = 'HSLIDER')
chsize = strtrim(string(charsize),2)
void = cw_field(tlb,value = chsize,title = 'Character Size',uname = 'CHARSIZE', $
   /return_events)
rowbase = widget_base(tlb,/row)
;void = widget_button(rowbase,value = 'ACCEPT',uname = 'ACCEPT')
void = widget_button(rowbase,value = 'DISMISS',uname = 'DISMISS')
widget_control,tlb,/realize

state = {notify_ids:notify_ids,prefs_ptr:ptr_new(prefs),nzx:nzx,nzy:nzy}
pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate
xmanager,register_name,tlb,/no_block,cleanup = 'leg_cleanup', $
   event_handler = 'dtas_legend_prefs_event'

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
