; $Id$
;###############################################################################
;
; NAME:
;  DAVE_INPUT_BOX
;
; PURPOSE:
;
; CATEGORY:
;  DAVE, TAS, Data Reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; +
;
; -
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dib_event,event
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
'CANCEL':   $
   begin
      (*pstate).cancel = 1B
      widget_control,event.top,/destroy
   end
'ACCEPT':   $
   begin
      field_id = widget_info(event.top,find_by_uname = 'TEXT')
      widget_control,field_id,get_value = value
      *(*pstate).pvalue = value
      widget_control,event.top,/destroy
   end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dave_input_box,group_leader = group_leader,title = title,value = value, $
   cancel = cancel
; Widget definition module
register_name = 'DAVE_INPUT_BOX'
cancel = 0B
if n_elements(group_leader) eq 0 then return,0
if n_elements(title) eq 0 then title = 'Input dialog'
if n_elements(value) eq 0 then value = 'None defined'
tlb = widget_base(group_leader = group_leader,/modal,title = title,/col, $
   tlb_frame_attr = 9)
field = cw_field(tlb,value = value,title = title,/all_events,uname = 'TEXT')
rowbase = widget_base(tlb,/row)
void = widget_button(rowbase,value = 'Cancel',uname = 'CANCEL')
void = widget_button(rowbase,value = 'Accept',uname = 'ACCEPT')
centertlb,tlb
widget_control,tlb,/realize
state = {pvalue:ptr_new(value),cancel:cancel}
pstate = ptr_new(state)
widget_control,tlb,set_uvalue = pstate
xmanager,register_name,tlb,event_handler = 'dib_event'
value = *(*pstate).pvalue
cancel = (*pstate).cancel
heap_free,pstate

return,value
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;