; $Id$
pro Spurion2_scan::setProperty,name=name,pstr=pstr,pgui=pgui,sourceFlag=sourceFlag,_Extra=extra

    if n_elements(name) ne 0 then self.name=name
    if n_elements(pstr) ne 0 then self.pstr=pstr
    if n_elements(pgui) ne 0 then self.pgui=pgui
    if n_elements(sourceFlag) ne 0 then self.sourceFlag=sourceFlag

end;setProperty

pro Spurion2_scan::getProperty,name=name,pstr=pstr,pgui=pgui,sourceFlag=sourceFlag,_Extra=extra

    if arg_present(name) ne 0 then name = self.name
    if arg_present(pstr) ne 0 then pstr = self.pstr
    if arg_present(pgui) ne 0 then pgui = self.pgui
    if arg_present(sourceFlag) ne 0 then sourceFlag = self.sourceFlag

end;getProperty

pro Spurion2_scan::cleanup

    if ptr_valid(self.pstr) then ptr_free,self.pstr
    if ptr_valid(self.pgui) then ptr_free,self.pgui

end;cleanup

function Spurion2_scan::init,str,gui,source


    if ptr_valid(self.pstr) then ptr_free,self.pstr
    if n_elements(str) gt 0 then begin
        self.name = file_basename(str.fn)
    endif else begin
        tas_scan_mapper_default_str,str
        ;run_lattice_default_str,str
        self.name = str.fn
    endelse
    self.pstr = ptr_new(str)
;print,'Spurion2_scan::init self.name=',self.name


    if ptr_valid(self.pgui) then ptr_free,self.pgui
    if n_elements(gui) gt 0 then begin
        self.pgui = ptr_new(gui)
    endif else begin
        self.pgui = ptr_new(0.0)
    endelse


    return,1
end;init


pro Spurion2_scan__define,class

    class = {Spurion2_scan,$
                sourceFlag:0,$
                name:'',$
                pstr:ptr_new(),$
                pgui:ptr_new()}

end;Spurion2_scan__define

